(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    248464,       5612]
NotebookOptionsPosition[    238608,       5428]
NotebookOutlinePosition[    239030,       5445]
CellTagsIndexPosition[    238987,       5442]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Setup", "Section",
 CellChangeTimes->{{3.472921133453125*^9, 3.472921136578125*^9}, {
  3.48059696478125*^9, 
  3.480596966078125*^9}},ExpressionUUID->"380c2fbf-221d-450f-85c0-\
947532017042"],

Cell[CellGroupData[{

Cell["Clear Memory", "Subsection",
 CellChangeTimes->{{3.577555845269595*^9, 
  3.577555854999609*^9}},ExpressionUUID->"5d7d8a07-3a1c-4c15-9387-\
b52979426b30"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.453223339859375*^9, 3.45322336209375*^9}, {
  3.4718973332790003`*^9, 3.471897335311*^9}, {3.5106685133125*^9, 
  3.510668513796875*^9}, {3.5363291848779287`*^9, 3.5363292263282995`*^9}, {
  3.543592532405407*^9, 3.543592532562416*^9}, {3.5657135773339033`*^9, 
  3.5657135783649626`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"7ed69aaa-fe6c-44dc-8f5a-308014ce3dd6"],

Cell[BoxData[
 TemplateBox[{
  "Remove", "rmnsm", 
   "\"There are no symbols matching \\\"\\!\\(\\*RowBox[{\\\"\\\\\\\"Global`*\
\\\\\\\"\\\"}]\\)\\\".\"", 2, 2, 1, 25513626908261174456, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9011919381073794`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"7c1a088b-924f-45ca-a35c-5624f15862d7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["System Size", "Subsection",
 CellChangeTimes->{{3.582407536044362*^9, 
  3.582407537822765*^9}},ExpressionUUID->"9d2ba320-92f3-4400-abf7-\
fc4cd642321e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ns", "=", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"n", "=", "24"}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"Number", " ", "of", " ", "Equations"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"nendo", "=", "18"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5824075512387886`*^9, 3.582407558399201*^9}, {
   3.586273229420745*^9, 3.5862732294907455`*^9}, 3.588350123742902*^9, {
   3.619622798834332*^9, 3.619622800534735*^9}, 3.6196240529907374`*^9, 
   3.6278336380324993`*^9, {3.629555511454953*^9, 3.629555511954954*^9}, {
   3.643218916575903*^9, 3.6432189169259033`*^9}, {3.6432239980796328`*^9, 
   3.6432239982496333`*^9}, {3.649006985506028*^9, 3.6490069857940445`*^9}, {
   3.668267780589054*^9, 3.6682677809490747`*^9}, {3.6720594461043916`*^9, 
   3.672059447694394*^9}, {3.7082787268066854`*^9, 3.7082787281057897`*^9}, 
   3.7097522226919055`*^9, {3.7099850077026196`*^9, 3.7099850077636194`*^9}, {
   3.7289094053469086`*^9, 3.7289094054105654`*^9}, {3.7352980008502164`*^9, 
   3.735298001114211*^9}, {3.735298177678096*^9, 3.7352981817096124`*^9}, {
   3.7354726676628833`*^9, 3.7354726680526657`*^9}, {3.735472768196027*^9, 
   3.73547276836335*^9}, 3.7435258309882855`*^9, 3.8837564724727173`*^9, 
   3.8842712275029335`*^9, 3.885643408764632*^9, 3.896545959175543*^9},
 CellLabel->"In[4]:=",ExpressionUUID->"93295281-a532-452e-b35e-6c9eae7b620e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equilibrium Conditions", "Subsection",
 CellChangeTimes->{{3.465644523125*^9, 
  3.46564452759375*^9}},ExpressionUUID->"823f04fd-5084-4dd0-963d-\
7a55f69e6b27"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"[", "01", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", "d", "]"}], "*", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", "c", "]"}], "-", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"Exp", "[", "h", "]"}], "oomega"], "oomega"]}], ")"}], 
      RowBox[{"-", "rrho"}]]}], "-", 
    RowBox[{"Exp", "[", "\[Mu]", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"[", "02", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "aalpha", "-", "eeta"}], ")"}], "*", 
     RowBox[{"Exp", "[", "a", "]"}], "*", 
     SuperscriptBox[
      RowBox[{"Exp", "[", "z", "]"}], "aalpha"], "*", 
     SuperscriptBox[
      RowBox[{"Exp", "[", "klag", "]"}], "eeta"], "*", 
     SuperscriptBox[
      RowBox[{"Exp", "[", "h", "]"}], "aalpha"], "*", 
     SuperscriptBox[
      RowBox[{"Exp", "[", "v", "]"}], 
      RowBox[{
       RowBox[{"-", "aalpha"}], "-", "eeta"}]]}], "-", 
    RowBox[{
     RowBox[{"Exp", "[", "p", "]"}], "*", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"pphi", "*", "r"}], "+", 
       RowBox[{
        FractionBox["\[Lambda]", 
         RowBox[{"Exp", "[", "\[Mu]", "]"}]], "*", "pphi", "*", 
        RowBox[{"(", 
         RowBox[{"1", "+", "r"}], ")"}]}]}], ")"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"[", "03", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"aalpha", "*", 
     RowBox[{"Exp", "[", "a", "]"}], "*", 
     SuperscriptBox[
      RowBox[{"Exp", "[", "z", "]"}], "aalpha"], "*", 
     SuperscriptBox[
      RowBox[{"Exp", "[", "klag", "]"}], "eeta"], "*", 
     SuperscriptBox[
      RowBox[{"Exp", "[", "h", "]"}], 
      RowBox[{"aalpha", "-", "1"}]], "*", 
     SuperscriptBox[
      RowBox[{"Exp", "[", "v", "]"}], 
      RowBox[{"1", "-", "aalpha", "-", "eeta"}]]}], "-", 
    RowBox[{"pphi", "*", 
     RowBox[{"Exp", "[", "w", "]"}], "*", 
     RowBox[{"(", 
      RowBox[{"r", "+", 
       RowBox[{
        FractionBox["\[Lambda]", 
         RowBox[{"Exp", "[", "\[Mu]", "]"}]], "*", 
        RowBox[{"(", 
         RowBox[{"1", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
    SuperscriptBox[
     RowBox[{"Exp", "[", "h", "]"}], 
     RowBox[{"oomega", "-", "1"}]]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"[", "04", "]"}], "]"}], "=", 
   RowBox[{"\[Lambda]", "+", 
    RowBox[{"bbeta", "*", 
     RowBox[{"(", 
      RowBox[{"1", "+", "r"}], ")"}], "*", 
     RowBox[{"Exp", "[", "\[Mu]p", "]"}], "*", 
     SuperscriptBox[
      RowBox[{"Exp", "[", "zp", "]"}], 
      RowBox[{"-", "rrho"}]]}], "-", 
    RowBox[{"Exp", "[", "\[Mu]", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"[", "05", "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", "\[Mu]", "]"}], "*", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"iiota", "*", 
         FractionBox[
          RowBox[{
           RowBox[{
            RowBox[{"Exp", "[", "k", "]"}], "*", 
            RowBox[{"Exp", "[", "z", "]"}]}], "-", 
           RowBox[{"\[CapitalLambda]k", "*", 
            RowBox[{"Exp", "[", "klag", "]"}]}]}], 
          RowBox[{"Exp", "[", "klag", "]"}]]}]}], ")"}]}], "-", 
     RowBox[{"\[Lambda]", "*", "kkappa", "*", 
      RowBox[{"Exp", "[", "q", "]"}]}], "-", 
     RowBox[{
      RowBox[{"Exp", "[", "\[Mu]p", "]"}], "*", 
      SuperscriptBox[
       RowBox[{"Exp", "[", "zp", "]"}], 
       RowBox[{"-", "rrho"}]], "*", "bbeta", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"eeta", "*", 
         RowBox[{"Exp", "[", "ap", "]"}], "*", 
         SuperscriptBox[
          RowBox[{"Exp", "[", "zp", "]"}], "aalpha"], "*", 
         SuperscriptBox[
          RowBox[{"Exp", "[", "k", "]"}], 
          RowBox[{"eeta", "-", "1"}]], "*", 
         SuperscriptBox[
          RowBox[{"Exp", "[", "hp", "]"}], "aalpha"], "*", 
         SuperscriptBox[
          RowBox[{"Exp", "[", "vp", "]"}], 
          RowBox[{"1", "-", "aalpha", "-", "eeta"}]]}], "+", "1", "-", 
        "ddelta", "+", 
        RowBox[{"iiota", "*", "\[CapitalLambda]k", "*", 
         RowBox[{"(", 
          FractionBox[
           RowBox[{
            RowBox[{
             RowBox[{"Exp", "[", "kp", "]"}], "*", 
             RowBox[{"Exp", "[", "zp", "]"}]}], "-", 
            RowBox[{"\[CapitalLambda]k", "*", 
             RowBox[{"Exp", "[", "k", "]"}]}]}], 
           RowBox[{"Exp", "[", "k", "]"}]], ")"}]}], "+", 
        RowBox[{
         FractionBox["iiota", "2"], "*", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox[
            RowBox[{
             RowBox[{
              RowBox[{"Exp", "[", "kp", "]"}], "*", 
              RowBox[{"Exp", "[", "zp", "]"}]}], "-", 
             RowBox[{"\[CapitalLambda]k", "*", 
              RowBox[{"Exp", "[", "k", "]"}]}]}], 
            RowBox[{"Exp", "[", "k", "]"}]], ")"}], "2"]}]}], ")"}]}]}]}], 
   ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"Market", " ", "Prices", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Equations", " ", "6"}], "-", "7"}], ")"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"[", "06", "]"}], "]"}], "=", 
   RowBox[{"1", "+", 
    RowBox[{"iiota", "*", 
     RowBox[{"(", 
      FractionBox[
       RowBox[{
        RowBox[{
         RowBox[{"Exp", "[", "k", "]"}], "*", 
         RowBox[{"Exp", "[", "z", "]"}]}], "-", 
        RowBox[{"\[CapitalLambda]k", "*", 
         RowBox[{"Exp", "[", "klag", "]"}]}]}], 
       RowBox[{"Exp", "[", "klag", "]"}]], ")"}]}], "-", 
    RowBox[{"Exp", "[", "q", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"[", "07", "]"}], "]"}], "=", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Exp", "[", "h", "]"}], 
      RowBox[{"oomega", "-", "1"}]], "-", 
     RowBox[{"Exp", "[", "w", "]"}]}]}], ";"}], "\n", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Budget", " ", "Constraints", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Equations", " ", "8"}], "-", "9"}], ")"}]}], " ", 
   "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"[", "08", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", "a", "]"}], "*", 
     SuperscriptBox[
      RowBox[{"Exp", "[", "z", "]"}], "aalpha"], "*", 
     SuperscriptBox[
      RowBox[{"Exp", "[", "klag", "]"}], "eeta"], "*", 
     SuperscriptBox[
      RowBox[{"Exp", "[", "h", "]"}], "aalpha"], "*", 
     SuperscriptBox[
      RowBox[{"Exp", "[", "v", "]"}], 
      RowBox[{"1", "-", "aalpha", "-", "eeta"}]]}], "-", 
    RowBox[{
     RowBox[{"Exp", "[", "p", "]"}], "*", 
     RowBox[{"Exp", "[", "v", "]"}]}], "-", 
    RowBox[{"pphi", "*", "r", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Exp", "[", "w", "]"}], "*", 
        RowBox[{"Exp", "[", "h", "]"}]}], "+", 
       RowBox[{
        RowBox[{"Exp", "[", "p", "]"}], "*", 
        RowBox[{"Exp", "[", "v", "]"}]}]}], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "+", "r"}]], "*", "b", "*", 
     RowBox[{"Exp", "[", "z", "]"}]}], "+", "blag", "-", 
    RowBox[{"Exp", "[", "c", "]"}], "-", 
    RowBox[{"Exp", "[", "inv", "]"}], "-", 
    RowBox[{
     RowBox[{"Exp", "[", "yss", "]"}], "*", 
     RowBox[{"Exp", "[", "e", "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"[", "09", "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "ddelta"}], ")"}], "*", 
      RowBox[{"Exp", "[", "klag", "]"}]}], "+", 
     RowBox[{"Exp", "[", "inv", "]"}], "-", 
     RowBox[{
      FractionBox["iiota", "2"], "*", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"Exp", "[", "k", "]"}], "*", 
           RowBox[{"Exp", "[", "z", "]"}]}], "-", 
          RowBox[{"\[CapitalLambda]k", "*", 
           RowBox[{"Exp", "[", "klag", "]"}]}]}], 
         RowBox[{"Exp", "[", "klag", "]"}]], ")"}], "2"], "*", 
      RowBox[{"Exp", "[", "klag", "]"}]}], "-", 
     RowBox[{
      RowBox[{"Exp", "[", "k", "]"}], "*", 
      RowBox[{"Exp", "[", "z", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
  "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Debt", " ", "Cushion", " ", "and", " ", "Borrowing", " ", "Limits", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Equations", " ", "10"}], "-", "11"}], ")"}]}], " ", 
   "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"[", "10", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "+", "r"}]], "*", "b", "*", 
     RowBox[{"Exp", "[", "z", "]"}]}], "-", 
    RowBox[{"pphi", "*", 
     RowBox[{"(", 
      RowBox[{"1", "+", "r"}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Exp", "[", "w", "]"}], "*", 
        RowBox[{"Exp", "[", "h", "]"}]}], "+", 
       RowBox[{
        RowBox[{"Exp", "[", "p", "]"}], "*", 
        RowBox[{"Exp", "[", "v", "]"}]}]}], ")"}]}], "+", 
    RowBox[{"kkappa", "*", 
     RowBox[{"Exp", "[", "q", "]"}], "*", 
     RowBox[{"Exp", "[", "k", "]"}], "*", 
     RowBox[{"Exp", "[", "z", "]"}]}], "-", "bstar"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"[", "11", "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"varphi", "[", "s", "]"}], "*", "bstarss"}], "+", 
     RowBox[{
      RowBox[{"nnu", "[", "s", "]"}], "*", 
      RowBox[{"(", 
       RowBox[{"bstar", "-", "bstarss"}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"varphi", "[", "s", "]"}]}], ")"}], "*", "\[Lambda]ss"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"nnu", "[", "s", "]"}]}], ")"}], "*", 
      RowBox[{"(", 
       RowBox[{"\[Lambda]", "-", "\[Lambda]ss"}], ")"}]}]}]}], ";"}], 
  "\[IndentingNewLine]", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"Interest", " ", "Rate", " ", 
    RowBox[{"(", 
     RowBox[{"Equations", " ", "12"}], ")"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"[", "12", "]"}], "]"}], "=", 
    RowBox[{"rstar", "+", 
     RowBox[{"ppsir", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"bbar", "-", "b"}], "]"}], "-", "1"}], ")"}]}], "-", "r"}]}],
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Auxiliary", " ", "Equation", " ", "for", " ", "Capital", " ", 
    RowBox[{"(", 
     RowBox[{"Equation", " ", "13"}], ")"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"[", "13", "]"}], "]"}], "=", 
    RowBox[{
     RowBox[{"Exp", "[", "k", "]"}], "-", 
     RowBox[{"Exp", "[", "k1", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Additional", " ", "Definitions", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Equations", " ", "14"}], "-", "16"}], ")"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"[", "14", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"Exp", "[", "y", "]"}], "-", 
    RowBox[{
     RowBox[{"Exp", "[", "a", "]"}], "*", 
     SuperscriptBox[
      RowBox[{"Exp", "[", "z", "]"}], "aalpha"], "*", 
     SuperscriptBox[
      RowBox[{"Exp", "[", "klag", "]"}], "eeta"], "*", 
     SuperscriptBox[
      RowBox[{"Exp", "[", "h", "]"}], "aalpha"], 
     SuperscriptBox[
      RowBox[{"Exp", "[", "v", "]"}], 
      RowBox[{"1", "-", "aalpha", "-", "eeta"}]]}], "+", 
    RowBox[{
     RowBox[{"Exp", "[", "p", "]"}], "*", 
     RowBox[{"Exp", "[", "v", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"[", "15", "]"}], "]"}], "=", 
   RowBox[{"bratio", "-", 
    RowBox[{"b", "*", 
     RowBox[{
      RowBox[{"Exp", "[", "z", "]"}], "/", 
      RowBox[{"Exp", "[", "y", "]"}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"[", "16", "]"}], "]"}], "=", 
   RowBox[{"caratio", "-", 
    FractionBox[
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{"Exp", "[", "z", "]"}]}], "-", "blag"}], 
     RowBox[{"Exp", "[", "y", "]"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"[", "17", "]"}], "]"}], "=", 
   RowBox[{"tbratio", "-", 
    FractionBox[
     RowBox[{
      RowBox[{"Exp", "[", "y", "]"}], "-", 
      RowBox[{
       RowBox[{"Exp", "[", "yss", "]"}], "*", 
       RowBox[{"Exp", "[", "e", "]"}]}], "-", 
      RowBox[{"Exp", "[", "c", "]"}], "-", 
      RowBox[{"Exp", "[", "inv", "]"}]}], 
     RowBox[{"Exp", "[", "y", "]"}]]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"[", "18", "]"}], "]"}], "=", 
    RowBox[{"efpd", "-", 
     FractionBox["\[Lambda]", 
      RowBox[{"bbeta", "*", 
       RowBox[{"Exp", "[", "\[Mu]p", "]"}], "*", 
       SuperscriptBox[
        RowBox[{"Exp", "[", "zp", "]"}], 
        RowBox[{"-", "rrho"}]]}]]}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Laws", " ", "of", " ", "Motion", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Equations", " ", "17"}], "-", "22"}], ")"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"[", "19", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "rrhoa"}], ")"}], "*", 
     RowBox[{"Log", "[", "abar", "]"}]}], "+", 
    RowBox[{"rrhoa", "*", "alag"}], "+", 
    RowBox[{"ssigmaa", "*", "\[Epsilon]a"}], "-", "a"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"[", "20", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "rrhoz"}], ")"}], "*", 
     RowBox[{"Log", "[", "zbar", "]"}]}], "+", 
    RowBox[{"rrhoz", "*", "zlag"}], "+", 
    RowBox[{"ssigmaz", "*", "\[Epsilon]z"}], "-", "z"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"[", "21", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "rrhop"}], ")"}], "*", 
     RowBox[{"Log", "[", "pbar", "]"}]}], "+", 
    RowBox[{"rrhop", "*", "plag"}], "+", 
    RowBox[{"ssigmap", "*", "\[Epsilon]p"}], "-", "p"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"[", "22", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"rrhod", "*", "dlag"}], "+", 
    RowBox[{"ssigmad", "*", "\[Epsilon]d"}], "-", "d"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"[", "23", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "rrhoe"}], ")"}], "*", 
     RowBox[{"Log", "[", "ebar", "]"}]}], "+", 
    RowBox[{"rrhoe", "*", "elag"}], "+", 
    RowBox[{"ssigmae", "*", "\[Epsilon]e"}], "-", "e"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"[", "24", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "rrhor"}], ")"}], "*", "rbar"}], "+", 
    RowBox[{"rrhor", "*", "rstarlag"}], "+", 
    RowBox[{"ssigmar", "*", "\[Epsilon]r"}], "-", "rstar"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.8626607766595416`*^9, 3.8626607776440487`*^9}, {
   3.862669404282748*^9, 3.8626694222737284`*^9}, {3.862670465212493*^9, 
   3.862670473293762*^9}, {3.862670515726639*^9, 3.862670518610391*^9}, 
   3.8726321842129154`*^9, {3.883756477796137*^9, 3.8837565066098433`*^9}, {
   3.8837565918621216`*^9, 3.883756644750208*^9}, {3.8837566761465836`*^9, 
   3.8837566764636283`*^9}, {3.8839550575857024`*^9, 
   3.8839550744573317`*^9}, {3.884271232613557*^9, 3.8842712716031036`*^9}, {
   3.8848988738842154`*^9, 3.8848988930855136`*^9}, {3.884962457436987*^9, 
   3.8849624634138823`*^9}, {3.8849860841501217`*^9, 3.884986094188148*^9}, {
   3.885643415892769*^9, 3.8856434547485476`*^9}, {3.885646269729697*^9, 
   3.885646281215766*^9}, {3.8965459434166574`*^9, 3.896546055314786*^9}, {
   3.896546105481018*^9, 3.8965461662808867`*^9}, {3.896567191775756*^9, 
   3.8965672928611007`*^9}, {3.896567351610964*^9, 3.896567351927001*^9}, {
   3.896567450667859*^9, 3.896567451091211*^9}, {3.8968007173101635`*^9, 
   3.896800819083542*^9}, {3.8968020329660835`*^9, 3.896802054340068*^9}, {
   3.896822958631751*^9, 3.896822962255658*^9}, {3.89688579281137*^9, 
   3.8968857932659645`*^9}, {3.896885853020838*^9, 3.896885860460693*^9}, {
   3.8969131016734734`*^9, 3.8969131036247883`*^9}, {3.8969143799483967`*^9, 
   3.8969143833411036`*^9}, 3.8969809398147593`*^9, {3.8969810073505545`*^9, 
   3.8969810159089656`*^9}, {3.8969811347263985`*^9, 3.896981228151194*^9}, {
   3.8969816230118165`*^9, 3.8969816230118165`*^9}, {3.8972369192767377`*^9, 
   3.897237072163242*^9}, {3.8977724082268543`*^9, 3.8977724188822956`*^9}, {
   3.901191912109262*^9, 3.9011919234922237`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"1be30df0-4127-41a0-81a0-2cf46a6c5e98"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Forward", " ", "Definitions"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"zp", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "rrhoz"}], ")"}], "*", 
       RowBox[{"Log", "[", "zbar", "]"}]}], "+", 
      RowBox[{"rrhoz", "*", "z"}], "+", 
      RowBox[{"ssigmaz", "*", "\[Chi]", "*", "\[Epsilon]zp"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ap", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "rrhoa"}], ")"}], "*", 
       RowBox[{"Log", "[", "abar", "]"}]}], "+", 
      RowBox[{"rrhoa", "*", "a"}], "+", 
      RowBox[{"ssigmaa", "*", "\[Chi]", "*", "\[Epsilon]ap"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[CapitalLambda]k", "=", "zbar"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.8965460423539395`*^9, 3.8965460549832954`*^9}, {
  3.8965461587263403`*^9, 3.8965461660459156`*^9}, {3.896800767313098*^9, 
  3.896800768147601*^9}, {3.901191924843154*^9, 3.901191926354692*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"307cd374-b37d-428e-bfa4-91caf5dfb519"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Print", " ", "Equilibrium", " ", "Conditions"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"f", "//", "MatrixForm"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ff", "=", "f"}], ";"}]}]], "Input",
 CellChangeTimes->{{3.6243726074691887`*^9, 3.624372609139191*^9}, {
   3.624372665354273*^9, 3.6243726980943193`*^9}, 3.646929449967928*^9, {
   3.6469298361482534`*^9, 3.6469298368082542`*^9}, {3.896567436529175*^9, 
   3.896567438188346*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"01f49d2a-d511-4e40-84f2-c9dd64c177fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Variables Definitions", "Subsection",
 CellChangeTimes->{{3.5359999768587947`*^9, 3.5359999836951857`*^9}, {
  3.615633630524619*^9, 
  3.6156336328847537`*^9}},ExpressionUUID->"99d3dcb5-72b1-4e05-ac7d-\
1418b9cc98f9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Non", "-", 
    RowBox[{"Predetermined", " ", "Variables"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"yvarsp", "=", 
     RowBox[{"{", 
      RowBox[{
      "cp", ",", "hp", ",", "vp", ",", "invp", ",", "kp", ",", "rp", ",", 
       "qp", ",", "wp", ",", "\[Mu]p", ",", "\[Lambda]p", ",", "bstarp", ",", 
       "yp", ",", "bratiop", ",", "caratiop", ",", "tbratiop", ",", "efpdp"}],
       "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"yvars", "=", 
     RowBox[{"{", 
      RowBox[{
      "c", ",", "h", ",", "v", ",", "inv", ",", "k1", ",", "r", ",", "q", ",",
        "w", ",", "\[Mu]", ",", "\[Lambda]", ",", "bstar", ",", "y", ",", 
       "bratio", ",", "caratio", ",", "tbratio", ",", "efpd"}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"yfuns", "=", 
     RowBox[{"{", 
      RowBox[{
      "cfun", ",", "hfun", ",", "vfun", ",", "invfun", ",", "k1fun", ",", 
       "rfun", ",", "qfun", ",", "wfun", ",", "\[Mu]fun", ",", "\[Lambda]fun",
        ",", "bstarfun", ",", "yfun", ",", "bratiofun", ",", "caratiofun", 
       ",", "tbratiofun", ",", "efpdfun"}], "}"}]}], ";", 
    RowBox[{"yvarss", "=", 
     RowBox[{"{", 
      RowBox[{
      "css", ",", "hss", ",", "vss", ",", "invss", ",", "kss", ",", "rss", 
       ",", "qss", ",", "wss", ",", "\[Mu]ss", ",", "\[Lambda]ss", ",", 
       "bstarss", ",", "yss", ",", "bratioss", ",", "caratioss", ",", 
       "tbratioss", ",", "efpdss"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Predetermined", " ", "Variables"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xvars", "=", 
     RowBox[{"{", 
      RowBox[{
      "k", ",", "b", ",", "a", ",", "z", ",", "p", ",", "rstar", ",", "e", 
       ",", "d"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xlag", "=", 
     RowBox[{"{", 
      RowBox[{
      "klag", ",", "blag", ",", "alag", ",", "zlag", ",", "plag", ",", 
       "rstarlag", ",", "elag", ",", "dlag"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xfuns", "=", 
     RowBox[{"{", 
      RowBox[{
      "kfun", ",", "bfun", ",", "afun", ",", "zfun", ",", "pfun", ",", 
       "rstarfun", ",", "efun", ",", "dfun"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xvarss", "=", 
     RowBox[{"{", 
      RowBox[{
      "kss", ",", "bss", ",", "ass", ",", "zss", ",", "pss", ",", "rstarss", 
       ",", "ess", ",", "dss"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Shocks", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"epsp", "=", 
     RowBox[{"{", 
      RowBox[{
      "\[Epsilon]ap", ",", "\[Epsilon]zp", ",", "\[Epsilon]pp", ",", 
       "\[Epsilon]rp", ",", "\[Epsilon]ep", ",", "\[Epsilon]dp"}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eps", "=", 
     RowBox[{"{", 
      RowBox[{
      "\[Epsilon]a", ",", "\[Epsilon]z", ",", "\[Epsilon]p", ",", 
       "\[Epsilon]r", ",", "\[Epsilon]e", ",", "\[Epsilon]d"}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Markov", " ", "Switching", " ", "Variables"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tvarsp", "=", 
     RowBox[{"{", 
      RowBox[{"varphi", "[", "sp", "]"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tvars", "=", 
     RowBox[{"{", 
      RowBox[{"varphi", "[", "s", "]"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"tvarpss", "=", 
     RowBox[{"{", "varphibar", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tvarss", "=", 
     RowBox[{"{", "varphibar", "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.8837565111878257`*^9, 3.883756581851205*^9}, {
   3.883868804596877*^9, 3.8838688053249173`*^9}, {3.884271275796172*^9, 
   3.884271305416452*^9}, {3.885643460783209*^9, 3.885643481631955*^9}, {
   3.8965460620518103`*^9, 3.896546086616991*^9}, 3.8965502547846766`*^9},
 CellLabel->"In[36]:=",ExpressionUUID->"1895bf6f-a3e6-4397-a61f-aa50bef231e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Functions", "Subsection",
 CellChangeTimes->{{3.549388834060892*^9, 
  3.5493888351169524`*^9}},ExpressionUUID->"e763a51b-04a9-4605-8831-\
c99fb65eb0e6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Define", " ", "States"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"state", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"{", 
       RowBox[{"xlag", ",", "eps", ",", "\[Chi]"}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"statep", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"{", 
       RowBox[{"xvars", ",", 
        RowBox[{"\[Chi]", "*", "epsp"}], ",", "\[Chi]"}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Function", " ", "Lists"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"yfunlist", "=", 
     RowBox[{"Through", "[", 
      RowBox[{"Apply", "[", 
       RowBox[{
        RowBox[{"Through", "[", 
         RowBox[{"Apply", "[", 
          RowBox[{"yfuns", ",", 
           RowBox[{"{", "_", "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", "__", "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xfunlist", "=", 
     RowBox[{"Through", "[", 
      RowBox[{"Apply", "[", 
       RowBox[{
        RowBox[{"Through", "[", 
         RowBox[{"Apply", "[", 
          RowBox[{"xfuns", ",", 
           RowBox[{"{", "_", "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", "__", "}"}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Define", " ", "Functions"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"funrulei", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Thread", "[", 
         RowBox[{"yvars", "\[Rule]", 
          RowBox[{"Through", "[", 
           RowBox[{"Apply", "[", 
            RowBox[{
             RowBox[{"Through", "[", 
              RowBox[{"Apply", "[", 
               RowBox[{"yfuns", ",", 
                RowBox[{"{", "s", "}"}]}], "]"}], "]"}], ",", "state"}], 
            "]"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Thread", "[", 
         RowBox[{"xvars", "\[Rule]", 
          RowBox[{"Through", "[", 
           RowBox[{"Apply", "[", 
            RowBox[{
             RowBox[{"Through", "[", 
              RowBox[{"Apply", "[", 
               RowBox[{"xfuns", ",", 
                RowBox[{"{", "s", "}"}]}], "]"}], "]"}], ",", "state"}], 
            "]"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Thread", "[", 
         RowBox[{"tvars", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"tvarss", "+", 
            RowBox[{"\[Chi]", "*", 
             RowBox[{"(", 
              RowBox[{"tvars", "-", "tvarss"}], ")"}]}]}], ")"}]}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"funrulej", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Thread", "[", 
         RowBox[{"yvarsp", "\[Rule]", 
          RowBox[{"Through", "[", 
           RowBox[{"Apply", "[", 
            RowBox[{
             RowBox[{"Through", "[", 
              RowBox[{"Apply", "[", 
               RowBox[{"yfuns", ",", 
                RowBox[{"{", "sp", "}"}]}], "]"}], "]"}], ",", "statep"}], 
            "]"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Thread", "[", 
         RowBox[{"tvarsp", "\[Rule]", 
          RowBox[{"(", 
           RowBox[{"tvarpss", "+", 
            RowBox[{"\[Chi]", "*", 
             RowBox[{"(", 
              RowBox[{"tvarsp", "-", "tvarpss"}], ")"}]}]}], ")"}]}], "]"}]}],
        "\[IndentingNewLine]", "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Apply", " ", "Functions"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f", " ", "=", " ", 
     RowBox[{
      RowBox[{"f", "/.", "funrulej"}], "/.", "funrulei"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6084090394914484`*^9, 3.6084090522741795`*^9}, {
   3.608410282801562*^9, 3.608410289635953*^9}, {3.608410332476403*^9, 
   3.6084103480282927`*^9}, {3.6084104946836805`*^9, 
   3.6084105195771046`*^9}, {3.6084108166840982`*^9, 
   3.6084108292958193`*^9}, {3.608410974673135*^9, 3.6084110247079964`*^9}, 
   3.6084110789821005`*^9, {3.608411244063543*^9, 3.6084112820497155`*^9}, {
   3.6084116574180593`*^9, 3.6084117409481764`*^9}, 3.6084134930631914`*^9, {
   3.6084136175463114`*^9, 3.608413646495967*^9}, {3.608413823115069*^9, 
   3.608413876134102*^9}, {3.6084144921143336`*^9, 3.60841449536652*^9}, {
   3.6084153345345173`*^9, 3.6084153437640452`*^9}, {3.6096770800670266`*^9, 
   3.609677081567029*^9}, {3.6686226016761136`*^9, 3.668622604936118*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"9b118144-4a9d-4e09-9749-992a6155d44a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["System Dimensions", "Subsection",
 CellChangeTimes->{{3.619622858769637*^9, 
  3.619622861172042*^9}},ExpressionUUID->"f51ce925-ac65-4602-9836-\
bceecdc280bc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Vector", " ", "Sizes"}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"ny", "=", 
     RowBox[{
      RowBox[{"Dimensions", "[", "yvars", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nx", "=", 
     RowBox[{
      RowBox[{"Dimensions", "[", "xvars", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ne", "=", 
     RowBox[{
      RowBox[{"Dimensions", "[", "eps", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nt", "=", 
     RowBox[{
      RowBox[{"Dimensions", "[", "tvars", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Check", ":", " ", 
     RowBox[{"Should", " ", "Print", " ", "Zero"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "-", "nx", "-", "ny"}], "//", "Print"}]}]}]], "Input",
 CellChangeTimes->{{3.619622863652446*^9, 3.6196228649472485`*^9}, 
   3.619622924539353*^9, {3.627836631195562*^9, 3.6278366315855627`*^9}, {
   3.646929450307928*^9, 3.646929450307928*^9}, {3.646929867360543*^9, 
   3.6469298678305435`*^9}, 3.647009785529489*^9},
 CellLabel->"In[56]:=",ExpressionUUID->"e632ded4-949d-46db-a57c-d4d938fccacf"],

Cell[BoxData["0"], "Print",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmVkYGAwBGIpw7LrBcffOF42Z/UpBNJ37n4SLgXSfQHvJ4Lo+Wti
p4Noi+9fvkqffONYXX8jRB5Iz7hkua301htHhcnTJ619/8YxT/zi6XVAurw+
4MoTIG3g1/kSRDsYLSzk+wA0t1ZAjh9I7xCzvLMCSFfE1vvd/vjG8XHQ3ZBf
QPo08/n230B6TdzX4yBabQ7nB9ZPbxyZUpVl3T+/cUxRmWTlAaR/nZlRKMTx
1vHpu+IyED3F7V2RCJAuEGo2kAHS56+cnAaiPwRqHQDR53qDzoDoV+zvjvUB
aT8rh4x+ID3PWs1qEpDeYzHp8wwgzaF9gnsmkBY4nsk3C6RO0tkYRJevLTi8
B0iXfX0x6yhI3cV7NseA9MuwiHvPgPRC3UX8z4G0+SNPnxTOt44qj2etBtHz
9K/+2AikOd3OuhwA0vO1OrPfAumNwrm7ubneOhZ7TTPKBNKXgvwfvBN46wgA
RoHJ/A==
  "],
 CellLabel->
  "During evaluation of \
In[56]:=",ExpressionUUID->"82f77765-a16b-4672-b669-affda3be0d0b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Regimes", "Subsection",
 CellChangeTimes->{{3.6196228242467766`*^9, 
  3.619622825026778*^9}},ExpressionUUID->"9d5f5a50-2a45-4706-9e3f-\
b66e58e96fb6"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"Transition", " ", "Matrices", "\[IndentingNewLine]", "Pmat"}], 
    "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "-", "p01"}], ",", "p01"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"p10", ",", 
        RowBox[{"1", "-", "p10"}]}], "}"}]}], "}"}]}], ";", 
   "\[IndentingNewLine]", 
   RowBox[{"probfuns", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p01", "\[Rule]", 
       FractionBox[
        RowBox[{"Exp", "[", 
         RowBox[{"ggamma00", "-", 
          RowBox[{"ggamma01", "*", "bstar"}]}], "]"}], 
        RowBox[{"1", "+", 
         RowBox[{"Exp", "[", 
          RowBox[{"ggamma00", "-", 
           RowBox[{"ggamma01", "*", "bstar"}]}], "]"}]}]]}], ",", 
      RowBox[{"p10", "\[Rule]", 
       FractionBox[
        RowBox[{"Exp", "[", 
         RowBox[{"ggamma10", "-", 
          RowBox[{"ggamma11", "*", "\[Lambda]"}]}], "]"}], 
        RowBox[{"1", "+", 
         RowBox[{"Exp", "[", 
          RowBox[{"ggamma10", "-", 
           RowBox[{"ggamma11", "*", "\[Lambda]"}]}], "]"}]}]]}]}], "}"}]}], 
   ";", "\[IndentingNewLine]", 
   RowBox[{"Pmat", "=", 
    RowBox[{
     RowBox[{"Pmat", "/.", "probfuns"}], "/.", "funrulei"}]}], ";"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8626694560101156`*^9, 3.8626694573296824`*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"a8052c66-2efa-4526-968d-7023dceaef5f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equilibrium Conditions with Probabilities", "Subsection",
 CellChangeTimes->{{3.615635820236863*^9, 3.6156358261001987`*^9}, {
  3.650990257111299*^9, 
  3.6509902594733067`*^9}},ExpressionUUID->"9db40362-5f70-471e-963c-\
76afbf18607b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Pfun", "[", 
        RowBox[{"s", ",", "sp"}], "]"}], "[", 
       RowBox[{"bstar", ",", "\[Lambda]"}], "]"}], "/.", "funrulei"}], ")"}], 
    "*", "f"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.650990611180583*^9, 3.6509906692219095`*^9}, {
  3.65099142661514*^9, 3.6509914286881466`*^9}, {3.650991553898637*^9, 
  3.6509915552256413`*^9}, {3.6510595217402143`*^9, 3.651059527510227*^9}, {
  3.708368786584796*^9, 3.708368787400877*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"b187f6c1-2cc2-42fe-9dd1-72b2dd4bcff8"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Perturbation Point", "Section",
 CellChangeTimes->{{3.48552555422005*^9, 
  3.4855255617237997`*^9}},ExpressionUUID->"1a79a8a6-8a0b-405f-8617-\
d0f0ac64d57c"],

Cell[CellGroupData[{

Cell["Rules", "Subsection",
 CellChangeTimes->{{3.474923433874*^9, 3.4749234344*^9}, 
   3.5493894292229333`*^9},ExpressionUUID->"c2808c04-4b5d-47bc-a43b-\
0b6f0db2253a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Rules", " ", "Sending", " ", "Variables", " ", "to", " ", "SS", " ", 
    "Values"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"derivrule", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", ":", 
        RowBox[{
         RowBox[{
          RowBox[{"Derivative", "[", "__", "]"}], "[", "_", "]"}], "[", "__", 
         "]"}]}], "\[RuleDelayed]", "\[VeryThinSpace]", 
       RowBox[{"d", "[", 
        RowBox[{"[", "0", "]"}], "]"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ssrule", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thread", "[", 
         RowBox[{"xlag", "\[Rule]", "xvarss"}], "]"}], ",", 
        RowBox[{"Thread", "[", 
         RowBox[{"xfunlist", "\[Rule]", "xvarss"}], "]"}], ",", 
        RowBox[{"Thread", "[", 
         RowBox[{"yfunlist", "\[Rule]", "yvarss"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Chi]", "\[Rule]", "0"}], "}"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Pfun", "[", 
           RowBox[{"s", ",", "sp"}], "]"}], "[", "__", "]"}], "\[Rule]", 
         RowBox[{"Pss", "[", 
          RowBox[{"s", ",", "sp"}], "]"}]}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"epsrule", "=", 
     RowBox[{"Thread", "[", 
      RowBox[{"eps", "\[Rule]", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"epsprule1", "=", 
     RowBox[{"Thread", "[", 
      RowBox[{"epsp", "\[Rule]", "0"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"epsprule2", "=", 
     RowBox[{"Thread", "[", 
      RowBox[{
       SuperscriptBox["epsp", "2"], "\[Rule]", "1"}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.4749234354049997`*^9, 3.474923446801*^9}, {
   3.47492349829*^9, 3.474923508083*^9}, {3.474923543475*^9, 
   3.4749237409110003`*^9}, 3.474923779901*^9, {3.4749245610699997`*^9, 
   3.47492471175*^9}, {3.4749249857279997`*^9, 3.4749250108970003`*^9}, {
   3.4749252735769997`*^9, 3.474925299558*^9}, {3.4749295216070004`*^9, 
   3.474929525333*^9}, 3.474929596758*^9, 3.474930396307*^9, {
   3.474931486099*^9, 3.474931486587*^9}, 3.47493161033*^9, {
   3.4750656713884*^9, 3.4750656786604*^9}, {3.4750742966432*^9, 
   3.4750743061032*^9}, {3.475682641140625*^9, 3.475682644*^9}, {
   3.476557113015625*^9, 3.476557116203125*^9}, {3.476634186140625*^9, 
   3.4766341985625*^9}, {3.47663447765625*^9, 3.476634492109375*^9}, {
   3.4768896582138*^9, 3.4768897020938*^9}, {3.47751102091*^9, 
   3.47751102465*^9}, {3.477511060112*^9, 3.4775110922469997`*^9}, {
   3.477513905223*^9, 3.4775139544049997`*^9}, {3.477513985082*^9, 
   3.477514016223*^9}, {3.477514051443*^9, 3.477514142685*^9}, {
   3.477514319148*^9, 3.477514322231*^9}, {3.477530487416*^9, 
   3.477530490678*^9}, {3.477530536773*^9, 3.4775305583780003`*^9}, {
   3.47758726915075*^9, 3.47758733135075*^9}, {3.477662244609375*^9, 
   3.477662257546875*^9}, {3.477663098*^9, 3.477663103859375*^9}, {
   3.4776632174375*^9, 3.477663217578125*^9}, {3.47766352*^9, 
   3.47766352671875*^9}, {3.477668975*^9, 3.477668975828125*^9}, {
   3.47766900825*^9, 3.477669013375*^9}, 3.477669058390625*^9, 
   3.477669273078125*^9, {3.477669625671875*^9, 3.477669630984375*^9}, {
   3.47767003778125*^9, 3.477670046421875*^9}, {3.4776843262426*^9, 
   3.4776843406706*^9}, {3.4781157131*^9, 3.478115737601*^9}, 
   3.47818579309375*^9, {3.4781897813125*^9, 3.4781898084375*^9}, {
   3.479211813046875*^9, 3.479211889484375*^9}, {3.479211921125*^9, 
   3.47921195228125*^9}, {3.479212164453125*^9, 3.47921219015625*^9}, {
   3.479212277265625*^9, 3.479212283390625*^9}, {3.4806821020625*^9, 
   3.480682115796875*^9}, {3.480762661390625*^9, 3.480762695359375*^9}, {
   3.481543146957209*^9, 3.481543154566584*^9}, {3.481544214519709*^9, 
   3.481544220566584*^9}, {3.481544507472834*^9, 3.481544512832209*^9}, {
   3.481544586113459*^9, 3.481544593222834*^9}, {3.481544702582209*^9, 
   3.481544702847834*^9}, {3.481545013629084*^9, 3.481545046988459*^9}, {
   3.481545079175959*^9, 3.481545079363459*^9}, {3.481545540785334*^9, 
   3.481545591769709*^9}, {3.481545622394709*^9, 3.481545672457209*^9}, {
   3.481552280082209*^9, 3.481552280300959*^9}, 3.481552559113459*^9, {
   3.481552617910334*^9, 3.481552642097834*^9}, {3.481552755800959*^9, 
   3.481552758207209*^9}, {3.4855255267588*^9, 3.4855255269188004`*^9}, {
   3.48552645552355*^9, 3.48552651888105*^9}, {3.4855268751630497`*^9, 
   3.4855269478817997`*^9}, {3.48552758015055*^9, 3.48552775712105*^9}, {
   3.4855281506033*^9, 3.4855281756665497`*^9}, {3.4855282084103003`*^9, 
   3.4855282642833*^9}, {3.4855283332908*^9, 3.48552833381705*^9}, {
   3.4855284188390503`*^9, 3.48552842682655*^9}, {3.4855284895015497`*^9, 
   3.4855284912128*^9}, {3.48552867352155*^9, 3.48552867904655*^9}, {
   3.48552872013655*^9, 3.4855287287740498`*^9}, {3.48552877913855*^9, 
   3.4855287806083*^9}, {3.4855290858483*^9, 3.4855290937845497`*^9}, {
   3.48552990717455*^9, 3.4855299091883*^9}, {3.48552996267955*^9, 
   3.4855299693833*^9}, {3.48553005422255*^9, 3.48553007295755*^9}, {
   3.48553016181555*^9, 3.4855301620230503`*^9}, {3.4855302269993*^9, 
   3.48553022997305*^9}, {3.48553067781905*^9, 3.4855306805703*^9}, {
   3.48553071526005*^9, 3.4855307240713*^9}, {3.4855307754337997`*^9, 
   3.4855307957038*^9}, {3.4855308281413*^9, 3.4855308433588*^9}, {
   3.4855309129108*^9, 3.4855309131183*^9}, {3.48553184430505*^9, 
   3.4855318907338*^9}, {3.48553665855655*^9, 3.4855366963328*^9}, {
   3.4855451023315496`*^9, 3.4855451108753*^9}, {3.48554521333255*^9, 
   3.48554527051455*^9}, {3.48554530936605*^9, 3.48554531292855*^9}, {
   3.48554542939755*^9, 3.4855455260525503`*^9}, {3.48554555941755*^9, 
   3.4855455733638*^9}, {3.4855464618580503`*^9, 3.48554646871555*^9}, {
   3.4856051444120502`*^9, 3.4856051507620497`*^9}, {3.48562729880875*^9, 
   3.4856272994987497`*^9}, {3.48571715887125*^9, 3.48571716074325*^9}, {
   3.4862049460597*^9, 3.4862049650977*^9}, {3.486310416933125*^9, 
   3.48631047251125*^9}, {3.4863746686441*^9, 3.4863746819066*^9}, {
   3.4863751191291*^9, 3.4863752539906*^9}, {3.4863753187946*^9, 
   3.4863754282486*^9}, 3.4863812950442*^9, {3.48924491007495*^9, 
   3.48924494723695*^9}, {3.49331240173*^9, 3.493312406494*^9}, {
   3.4933125816099997`*^9, 3.4933126128450003`*^9}, {3.493314692177*^9, 
   3.493314692382*^9}, {3.4933158290880003`*^9, 3.493315866174*^9}, {
   3.493315984144*^9, 3.49331601485*^9}, {3.50858841825235*^9, 
   3.50858843377535*^9}, {3.50858855348035*^9, 3.50858857110035*^9}, {
   3.50858861679535*^9, 3.50858866308335*^9}, {3.50858870944335*^9, 
   3.5085887287203503`*^9}, {3.50858879101235*^9, 3.50858884957135*^9}, {
   3.5085889001813498`*^9, 3.50858892505935*^9}, {3.50858896936335*^9, 
   3.50858907029635*^9}, {3.5085891537863503`*^9, 3.50858915397335*^9}, {
   3.50858923410435*^9, 3.5085892355893497`*^9}, {3.50858927724235*^9, 
   3.5085893645563498`*^9}, {3.50858945431535*^9, 3.50858947671235*^9}, {
   3.5085895541873503`*^9, 3.5085895997393503`*^9}, {3.50859143499435*^9, 
   3.50859143641835*^9}, {3.50859160774835*^9, 3.5085917147613497`*^9}, 
   3.50859176242835*^9, {3.510666723546875*^9, 3.51066674434375*^9}, {
   3.51066677778125*^9, 3.51066678871875*^9}, {3.510666868203125*^9, 
   3.51066693875*^9}, 3.510666971484375*^9, {3.510667164078125*^9, 
   3.510667180296875*^9}, {3.51066725790625*^9, 3.5106673049375*^9}, {
   3.51066982546875*^9, 3.5106698383125*^9}, {3.510671226015625*^9, 
   3.51067128346875*^9}, {3.51067131534375*^9, 3.510671343171875*^9}, {
   3.5106713938125*^9, 3.510671414296875*^9}, {3.510671600703125*^9, 
   3.51067160678125*^9}, {3.51715008796875*^9, 3.517150090140625*^9}, {
   3.517150437265625*^9, 3.51715044896875*^9}, {3.517150584046875*^9, 
   3.51715059759375*^9}, {3.517150634796875*^9, 3.5171506515625*^9}, {
   3.517150754265625*^9, 3.517150754484375*^9}, {3.517151549*^9, 
   3.51715157053125*^9}, {3.517322244140625*^9, 3.517322258375*^9}, {
   3.517322296953125*^9, 3.51732230790625*^9}, {3.51732234765625*^9, 
   3.517322349015625*^9}, {3.517322388421875*^9, 3.51732239859375*^9}, {
   3.51732272815625*^9, 3.51732273046875*^9}, {3.517322932828125*^9, 
   3.517322948453125*^9}, {3.5173229938125*^9, 3.51732299509375*^9}, {
   3.5202730040735254`*^9, 3.5202730063386545`*^9}, 3.5202731172960014`*^9, 
   3.5202733417888412`*^9, {3.5202748936676035`*^9, 3.520274899297926*^9}, {
   3.5202749352549825`*^9, 3.5202749373191004`*^9}, {3.5202757064510927`*^9, 
   3.5202757306264753`*^9}, {3.5202757652904577`*^9, 3.520275770314745*^9}, {
   3.5203568933199997`*^9, 3.520357061439616*^9}, {3.52035736379991*^9, 
   3.5203573658000245`*^9}, {3.520357395863744*^9, 3.5203574366940794`*^9}, {
   3.520357542031104*^9, 3.520357697334987*^9}, {3.52035775857749*^9, 
   3.5203579414619503`*^9}, 3.5203579763809476`*^9, {3.520358377110868*^9, 
   3.520358377517891*^9}, 3.520358577839349*^9, 3.520358804175295*^9, {
   3.520359621918067*^9, 3.520359626222313*^9}, {3.520359858590604*^9, 
   3.520359887767273*^9}, {3.520853579903921*^9, 3.5208538641921816`*^9}, {
   3.520854046312598*^9, 3.5208540974815254`*^9}, {3.5208542559205875`*^9, 
   3.5208542763117533`*^9}, {3.520854325359559*^9, 3.5208543336000304`*^9}, {
   3.5208550285367785`*^9, 3.520855048506921*^9}, {3.5208572786989503`*^9, 
   3.520857327232726*^9}, {3.520875635751964*^9, 3.5208756746241875`*^9}, 
   3.5359963710675554`*^9, {3.535996434886205*^9, 3.5359964649439244`*^9}, {
   3.5359965046131935`*^9, 3.5359965906671157`*^9}, {3.5359966790991735`*^9, 
   3.535996832030921*^9}, {3.5359969147106495`*^9, 3.5359970868164935`*^9}, {
   3.535997137923417*^9, 3.5359971637648945`*^9}, {3.535997222650263*^9, 
   3.535997227999569*^9}, {3.535997999231681*^9, 3.5359980695587034`*^9}, {
   3.5359981039446697`*^9, 3.535998104158682*^9}, 3.5359982814148207`*^9, {
   3.5359984334935193`*^9, 3.5359984401829014`*^9}, {3.535998486409546*^9, 
   3.535998537919492*^9}, {3.5359986157319427`*^9, 3.5359986218932953`*^9}, {
   3.535998976913601*^9, 3.535998981588868*^9}, 3.5360009310673723`*^9, 
   3.5360010541354113`*^9, 3.5360012299034643`*^9, {3.5360020321363497`*^9, 
   3.53600203423947*^9}, {3.5360021095537777`*^9, 3.536002118075265*^9}, {
   3.5360035588656735`*^9, 3.536003559247696*^9}, {3.5360041232059517`*^9, 
   3.5360041579869413`*^9}, {3.5360041916598673`*^9, 3.536004194271017*^9}, {
   3.5360813492300525`*^9, 3.536081352236224*^9}, {3.5360835047053385`*^9, 
   3.5360835185991335`*^9}, {3.536083574583336*^9, 3.5360836229971046`*^9}, {
   3.536083787320503*^9, 3.5360837876965246`*^9}, {3.536083967408804*^9, 
   3.5360843170418015`*^9}, {3.536084351860793*^9, 3.536084352956856*^9}, {
   3.536084420985747*^9, 3.536084422809851*^9}, {3.53608445425665*^9, 
   3.536084454480663*^9}, {3.53608449517099*^9, 3.536084506816656*^9}, {
   3.536086999201645*^9, 3.5360870059250298`*^9}, {3.5360870816773624`*^9, 
   3.5360870836054726`*^9}, {3.536087175185711*^9, 3.536087178681911*^9}, {
   3.5360878638310995`*^9, 3.536087866450249*^9}, {3.536088342313467*^9, 
   3.5360883487978377`*^9}, {3.536329073056533*^9, 3.53632908874943*^9}, {
   3.536329316170438*^9, 3.536329334117464*^9}, {3.5363293705235467`*^9, 
   3.5363294517231913`*^9}, {3.536329755703578*^9, 3.536329756942649*^9}, {
   3.536334310450094*^9, 3.536334339692767*^9}, {3.5363345956924095`*^9, 
   3.5363345994416237`*^9}, {3.5363350044037867`*^9, 
   3.5363350102461205`*^9}, {3.5364968413140583`*^9, 3.536496921662654*^9}, {
   3.5364971857917614`*^9, 3.5364972263590813`*^9}, {3.5364977930724955`*^9, 
   3.536497799224848*^9}, {3.5365008308582473`*^9, 3.536500834669465*^9}, {
   3.5367818906497*^9, 3.5367818978487*^9}, {3.5367824664477*^9, 
   3.5367825099526997`*^9}, {3.5367836293437*^9, 3.5367836599967003`*^9}, {
   3.5367837738677*^9, 3.5367837900337*^9}, {3.5367849197039003`*^9, 
   3.5367849561099*^9}, {3.5368592827883*^9, 3.5368593168833*^9}, {
   3.536929141049206*^9, 3.536929170631898*^9}, {3.536944326889723*^9, 
   3.5369443287048264`*^9}, {3.5369457147321024`*^9, 
   3.5369457234696026`*^9}, {3.536945758557609*^9, 3.536945762753849*^9}, {
   3.5369490924102945`*^9, 3.536949102957898*^9}, {3.536952304756203*^9, 
   3.5369524129193897`*^9}, {3.5369525614238834`*^9, 3.536952574509632*^9}, {
   3.536952779576361*^9, 3.5369527892979174`*^9}, {3.5369530597443857`*^9, 
   3.5369530671448092`*^9}, {3.5370296254461155`*^9, 3.537029648422429*^9}, {
   3.5371007206210976`*^9, 3.537100729349597*^9}, {3.5371008373027716`*^9, 
   3.5371008451322193`*^9}, {3.5371010514440193`*^9, 3.537101053794154*^9}, {
   3.5371011321386347`*^9, 3.5371011346977816`*^9}, {3.5371977407370005`*^9, 
   3.537197744453213*^9}, {3.537198122716849*^9, 3.5371981271120996`*^9}, {
   3.5371982609037523`*^9, 3.5371982700422754`*^9}, {3.5371992741067047`*^9, 
   3.537199277240884*^9}, {3.5372000490840306`*^9, 3.537200054233325*^9}, {
   3.537200278824171*^9, 3.5372002851115303`*^9}, {3.5372006277661295`*^9, 
   3.537200632993428*^9}, {3.537204877884222*^9, 3.537204882815504*^9}, {
   3.5372099297471724`*^9, 3.537209935285489*^9}, {3.537210124197294*^9, 
   3.5372101294825964`*^9}, {3.5372249835522003`*^9, 3.5372249870892*^9}, {
   3.5372252561001997`*^9, 3.5372252892032003`*^9}, {3.5372254784502*^9, 
   3.5372254844972*^9}, {3.5372259659042*^9, 3.5372259749772*^9}, {
   3.537287593632909*^9, 3.5372876100118456`*^9}, {3.5372887591345716`*^9, 
   3.5372888023840456`*^9}, {3.5372893913307314`*^9, 3.537289397799101*^9}, {
   3.537289431589034*^9, 3.5372896505325565`*^9}, {3.537289727663968*^9, 
   3.537289909752383*^9}, {3.5372902460146165`*^9, 3.5372902908331795`*^9}, {
   3.5372904496662645`*^9, 3.5372906408461995`*^9}, {3.537290698662506*^9, 
   3.5372907248560047`*^9}, {3.5372908797408633`*^9, 3.537290929230694*^9}, {
   3.5372909645147123`*^9, 3.537290992560316*^9}, {3.537291028184354*^9, 
   3.537291118731533*^9}, {3.5372912733963795`*^9, 3.537291542579776*^9}, {
   3.537291869716487*^9, 3.5372918705655355`*^9}, {3.537291927921816*^9, 
   3.537291945671831*^9}, {3.537292100629694*^9, 3.537292116873623*^9}, {
   3.5372926672731047`*^9, 3.537292709588525*^9}, {3.53729305813046*^9, 
   3.537293058360473*^9}, {3.5372932390748096`*^9, 3.537293239584839*^9}, {
   3.537296427094154*^9, 3.537296427817195*^9}, 3.537296488157646*^9, {
   3.537301308671364*^9, 3.537301340281172*^9}, {3.5373725863965616`*^9, 
   3.5373725923559027`*^9}, {3.537373192232213*^9, 3.5373732020507746`*^9}, {
   3.5373736053358417`*^9, 3.537373612665261*^9}, {3.537702706113759*^9, 
   3.537702760937895*^9}, {3.5377028430145893`*^9, 3.537702873814351*^9}, {
   3.5377037457812247`*^9, 3.5377037508825164`*^9}, {3.5377042168951707`*^9, 
   3.5377042232345333`*^9}, {3.537704674666354*^9, 3.5377046797096424`*^9}, 
   3.53770502810557*^9, {3.5377050656987195`*^9, 3.537705072456106*^9}, {
   3.5426315507399073`*^9, 3.5426317650671663`*^9}, {3.542631967621752*^9, 
   3.5426319758972254`*^9}, {3.542632933413992*^9, 3.5426329412744417`*^9}, {
   3.5426397967237153`*^9, 3.5426398174369*^9}, {3.5426404232435503`*^9, 
   3.5426404284978504`*^9}, {3.542640464700921*^9, 3.5426404683301287`*^9}, {
   3.5426405359079943`*^9, 3.5426405393601913`*^9}, {3.5426406141784706`*^9, 
   3.542640625060093*^9}, {3.5426437735867615`*^9, 3.5426437768979506`*^9}, {
   3.5426438381854563`*^9, 3.542643864105939*^9}, {3.542644510857931*^9, 
   3.5426445220675716`*^9}, {3.542644557129577*^9, 3.542644562810902*^9}, {
   3.542644655920228*^9, 3.5426446621255827`*^9}, {3.5426447321375875`*^9, 
   3.5426447373328843`*^9}, {3.54264480876297*^9, 3.5426448146623073`*^9}, 
   3.542645278301826*^9, {3.5426455909647093`*^9, 3.542645595435965*^9}, {
   3.5426457450285215`*^9, 3.542645781707619*^9}, {3.542646515877611*^9, 
   3.542646521463931*^9}, {3.54264756783978*^9, 3.5426475722220306`*^9}, {
   3.542647815668955*^9, 3.5426479892858853`*^9}, {3.5426488872562466`*^9, 
   3.54264891075259*^9}, {3.542648948844769*^9, 3.5426489710390387`*^9}, {
   3.5426522890018153`*^9, 3.542652398278065*^9}, {3.5426524685790863`*^9, 
   3.5426525024830256`*^9}, {3.542993150828664*^9, 3.5429931573470364`*^9}, {
   3.5429934550520644`*^9, 3.5429934729100857`*^9}, {3.5429940071696434`*^9, 
   3.5429940239226017`*^9}, {3.542994301234463*^9, 3.542994320038539*^9}, 
   3.5431636945614476`*^9, {3.5431637283523808`*^9, 3.5431637451093388`*^9}, {
   3.5431637880867968`*^9, 3.5431637902019176`*^9}, {3.543163881763155*^9, 
   3.543163918238241*^9}, {3.54316408256364*^9, 3.543164082652645*^9}, 
   3.543164138115817*^9, {3.5431654650977163`*^9, 3.54316548509486*^9}, {
   3.5431656887955112`*^9, 3.5431656935897856`*^9}, {3.5431658116285367`*^9, 
   3.543165821932126*^9}, {3.543165909082111*^9, 3.5431659133583555`*^9}, 
   3.543166616940598*^9, 3.543167073579752*^9, {3.543167134107858*^9, 
   3.5431671342638583`*^9}, {3.5431672099395914`*^9, 3.543167232622031*^9}, {
   3.5431676808927374`*^9, 3.54316769895277*^9}, {3.543167835114558*^9, 
   3.5431678401578465`*^9}, {3.54316806696682*^9, 3.5431680711310577`*^9}, {
   3.5431683559613495`*^9, 3.543168361558669*^9}, {3.543169410131571*^9, 
   3.5431694139535775`*^9}, {3.5431695860374794`*^9, 3.543169602479909*^9}, {
   3.543169706079691*^9, 3.543169709870497*^9}, {3.543171259147977*^9, 
   3.5431712849304514`*^9}, {3.5431714612835383`*^9, 3.543171475910375*^9}, {
   3.543171576320118*^9, 3.543171581339405*^9}, {3.5431716987911234`*^9, 
   3.5431717036023984`*^9}, {3.543171830598662*^9, 3.5431718357969594`*^9}, 
   3.5432320272757444`*^9, {3.543232544502328*^9, 3.543232548626564*^9}, {
   3.5432327066626034`*^9, 3.543232710538825*^9}, {3.5432328262504435`*^9, 
   3.543232830691697*^9}, 3.543233861203639*^9, {3.543235222123479*^9, 
   3.5432352741604557`*^9}, {3.543235552420371*^9, 3.543235580061952*^9}, {
   3.543236102238819*^9, 3.5432361035458937`*^9}, {3.543236220162564*^9, 
   3.543236233265313*^9}, {3.543236359112511*^9, 3.5432363636917734`*^9}, {
   3.543242538050926*^9, 3.543242543691249*^9}, {3.5432439600732613`*^9, 
   3.5432439602162695`*^9}, {3.5432465340374837`*^9, 3.54324653799471*^9}, {
   3.543246658092579*^9, 3.5432466623208213`*^9}, {3.543246773053155*^9, 
   3.543246778199449*^9}, {3.5432474593794103`*^9, 3.543247474865296*^9}, {
   3.5432476986780977`*^9, 3.543247703553376*^9}, 3.543248170922108*^9, {
   3.543250551208253*^9, 3.543250564220997*^9}, {3.5432506987506914`*^9, 
   3.5432507030699387`*^9}, {3.543254026518029*^9, 3.5432540460321455`*^9}, {
   3.54325421343472*^9, 3.543254223587301*^9}, {3.5432544749566784`*^9, 
   3.5432544799449635`*^9}, {3.5433181762527823`*^9, 
   3.5433181798739896`*^9}, {3.5433183635934973`*^9, 
   3.5433183654266024`*^9}, {3.5433184064949512`*^9, 
   3.5433184075630126`*^9}, {3.5433191050229053`*^9, 
   3.5433191115592785`*^9}, {3.543319285595233*^9, 3.543319289575461*^9}, {
   3.543319736558027*^9, 3.5433197556181173`*^9}, {3.5433210698292856`*^9, 
   3.5433211115766735`*^9}, {3.5433213405277686`*^9, 3.543321354914592*^9}, {
   3.543322295730403*^9, 3.5433223263491545`*^9}, {3.54332251841714*^9, 
   3.543322522631381*^9}, {3.5433227691874833`*^9, 3.5433227834262977`*^9}, {
   3.5433231717955112`*^9, 3.5433232216303616`*^9}, {3.543323387777609*^9, 
   3.54332340512484*^9}, {3.5433236083863077`*^9, 3.5433236123385344`*^9}, {
   3.5433348992862186`*^9, 3.5433349675201216`*^9}, {3.543335297209082*^9, 
   3.543335302497492*^9}, {3.543578443302827*^9, 3.543578447786083*^9}, {
   3.543578554018159*^9, 3.5435785698550653`*^9}, {3.5435795163051987`*^9, 
   3.543579531508068*^9}, {3.5435809284919715`*^9, 3.5435809327412148`*^9}, {
   3.5435810407093897`*^9, 3.5435810530210943`*^9}, {3.5435843869957867`*^9, 
   3.543584439066765*^9}, {3.543584722000948*^9, 3.543584736449774*^9}, {
   3.543584834578387*^9, 3.5435848383086*^9}, 3.543587629309966*^9, {
   3.543592542703996*^9, 3.5435926048735523`*^9}, {3.5435927117686663`*^9, 
   3.5435927154118743`*^9}, {3.5435928466633816`*^9, 3.543592850037575*^9}, {
   3.5435942671786304`*^9, 3.5435943149303617`*^9}, {3.5435945120026336`*^9, 
   3.5435945246633577`*^9}, {3.543594852809127*^9, 3.5435948932474394`*^9}, {
   3.5435951352012787`*^9, 3.5435951496931076`*^9}, 3.5435957343595486`*^9, {
   3.543596384179716*^9, 3.543596421726864*^9}, {3.5435966428145094`*^9, 
   3.5435966470167494`*^9}, {3.543679806441809*^9, 3.5436798162393694`*^9}, {
   3.5436802266308427`*^9, 3.5436802451169*^9}, {3.5436803319048643`*^9, 
   3.5436803362281113`*^9}, {3.5436805572377524`*^9, 
   3.5436805695084543`*^9}, {3.543682596873413*^9, 3.543682597048423*^9}, {
   3.54368262794619*^9, 3.5436826399468765`*^9}, {3.5436827458119316`*^9, 
   3.5436827530023427`*^9}, {3.54368284210944*^9, 3.5436828467267036`*^9}, {
   3.5436846089814987`*^9, 3.54368461057259*^9}, {3.5438574108226614`*^9, 
   3.5438574268895802`*^9}, {3.5438575715248528`*^9, 
   3.5438575749300475`*^9}, {3.5438598175973206`*^9, 
   3.5438598341712685`*^9}, {3.543859989560157*^9, 3.5438600221050177`*^9}, {
   3.5439244552324147`*^9, 3.5439244585506043`*^9}, {3.5439246570239563`*^9, 
   3.54392467089675*^9}, {3.543924905814186*^9, 3.543924935573889*^9}, {
   3.5441878221516466`*^9, 3.5441878704844112`*^9}, {3.544187982856838*^9, 
   3.5441880252132607`*^9}, {3.544188388975067*^9, 3.5441884047179675`*^9}, {
   3.544188820376742*^9, 3.5441888731057577`*^9}, {3.5441890903031807`*^9, 
   3.5441891415561123`*^9}, {3.5441950350241604`*^9, 3.544195043838664*^9}, {
   3.5441951765872574`*^9, 3.5441951878999043`*^9}, {3.544195321254532*^9, 
   3.5441953472750196`*^9}, {3.5441960350283575`*^9, 
   3.5441960632449713`*^9}, {3.5441968095866594`*^9, 3.544196847106806*^9}, {
   3.5441991756219893`*^9, 3.544199244570933*^9}, {3.544200050397023*^9, 
   3.544200106311221*^9}, {3.544279077204401*^9, 3.544279104343953*^9}, {
   3.544279153800782*^9, 3.5442791893508153`*^9}, {3.5442792660071993`*^9, 
   3.544279269491399*^9}, {3.544279871865853*^9, 3.54427989489717*^9}, {
   3.544279985932377*^9, 3.544279991381689*^9}, {3.5442862699548025`*^9, 
   3.544286354144618*^9}, {3.5442864922112217`*^9, 3.544286495861628*^9}, {
   3.5442866406308823`*^9, 3.544286643766488*^9}, {3.544286691402567*^9, 
   3.5442866951177793`*^9}, {3.544290362915064*^9, 3.544290368782399*^9}, {
   3.5443796764012303`*^9, 3.5443796899108543`*^9}, {3.544379810995802*^9, 
   3.5443798160880933`*^9}, {3.5445395890912433`*^9, 3.544539598011753*^9}, {
   3.544540405074915*^9, 3.544540405815957*^9}, {3.544542616672411*^9, 
   3.5445426174874573`*^9}, {3.544544564005766*^9, 3.544544598011711*^9}, {
   3.5445446787373285`*^9, 3.544544682358536*^9}, {3.544545456622821*^9, 
   3.5445454676814537`*^9}, {3.544545502170426*^9, 3.5445455058406363`*^9}, {
   3.5445460643175793`*^9, 3.5445460651796284`*^9}, {3.5447901496296196`*^9, 
   3.5447901570010414`*^9}, {3.5447902234518423`*^9, 
   3.5447902390887365`*^9}, {3.544790872172947*^9, 3.544790873332013*^9}, {
   3.5447930273202143`*^9, 3.5447930704006786`*^9}, {3.544805230834215*^9, 
   3.544805234908448*^9}, {3.544806375541689*^9, 3.544806390983572*^9}, {
   3.5448064835074263`*^9, 3.544806530245108*^9}, {3.544807680697101*^9, 
   3.5448076842203026`*^9}, {3.544809734709584*^9, 3.5448097422960176`*^9}, {
   3.5448857685909605`*^9, 3.5448857906752243`*^9}, {3.544886173531122*^9, 
   3.5448861913791428`*^9}, {3.544886537399934*^9, 3.5448865376839504`*^9}, {
   3.5448937473663206`*^9, 3.544893763128222*^9}, {3.544893795509074*^9, 
   3.5448937958300924`*^9}, {3.5448939834638243`*^9, 
   3.5448939866050043`*^9}, {3.5448941347974806`*^9, 
   3.5448941388827143`*^9}, {3.544894269697196*^9, 3.5448942732864017`*^9}, {
   3.5448949970878005`*^9, 3.544895020063115*^9}, {3.5448970852788196`*^9, 
   3.5448970880556245`*^9}, {3.544980534789818*^9, 3.5449806021356697`*^9}, {
   3.544980705898605*^9, 3.5449807090487847`*^9}, {3.5449808065123596`*^9, 
   3.5449808096525393`*^9}, {3.544980853143027*^9, 3.5449808553491526`*^9}, {
   3.5449814472420073`*^9, 3.544981451413246*^9}, {3.545320857710656*^9, 
   3.5453208773677807`*^9}, {3.545320976581455*^9, 3.5453209951055145`*^9}, {
   3.54532111986065*^9, 3.545321122980829*^9}, {3.545389444914645*^9, 
   3.545389445228663*^9}, {3.5453897268757725`*^9, 3.545389777838687*^9}, {
   3.5453898580082726`*^9, 3.545389862027502*^9}, {3.5453900500112543`*^9, 
   3.545390055133548*^9}, {3.545391331053526*^9, 3.5453913440422688`*^9}, {
   3.5454154012478876`*^9, 3.545415414381639*^9}, {3.5454155993572187`*^9, 
   3.5454156044165087`*^9}, {3.5454179994764605`*^9, 
   3.5454180164164295`*^9}, {3.545418057062754*^9, 3.5454180603439417`*^9}, {
   3.5454181863241477`*^9, 3.545418190191369*^9}, {3.545418275844268*^9, 
   3.545418279239462*^9}, {3.5454972819479947`*^9, 3.545497282282014*^9}, {
   3.545498758885471*^9, 3.545498774489363*^9}, {3.545498898582461*^9, 
   3.5454989019236517`*^9}, {3.5454993564696503`*^9, 3.545499359625831*^9}, {
   3.5456567771593904`*^9, 3.545656805014983*^9}, {3.5493854087678537`*^9, 
   3.5493854095448985`*^9}, {3.5493854613348603`*^9, 
   3.5493854952888026`*^9}, {3.549385535349094*^9, 3.5493856423792157`*^9}, {
   3.5493856780662565`*^9, 3.5493858251866713`*^9}, {3.549385891858485*^9, 
   3.549385910022524*^9}, {3.549386177432819*^9, 3.5493864755638714`*^9}, {
   3.549386566928097*^9, 3.549386567364122*^9}, {3.5493866283226085`*^9, 
   3.5493866308587537`*^9}, {3.549386733198607*^9, 3.5493867365818005`*^9}, 
   3.5493890384735837`*^9, {3.549389264750526*^9, 3.5493892705218563`*^9}, {
   3.549389341696927*^9, 3.549389343039004*^9}, {3.549389403553465*^9, 
   3.549389440477577*^9}, {3.549389499021926*^9, 3.549389516901948*^9}, {
   3.5493895918612356`*^9, 3.5493896464933605`*^9}, 3.549390255033167*^9, {
   3.5493904576567564`*^9, 3.549390464113126*^9}, {3.5493905971017323`*^9, 
   3.549390599530871*^9}, {3.549390711662285*^9, 3.549390718796693*^9}, {
   3.5493909539661436`*^9, 3.5493909571303244`*^9}, 3.5493910571530457`*^9, 
   3.549629215800749*^9, {3.5496301204044895`*^9, 3.5496301905495014`*^9}, {
   3.549632284514269*^9, 3.549632284593274*^9}, 3.5496323344621263`*^9, {
   3.5496378780031986`*^9, 3.54963789114095*^9}, {3.549641150699631*^9, 
   3.5496411513136663`*^9}, {3.549642937228815*^9, 3.549642937411825*^9}, {
   3.5496448849842205`*^9, 3.5496448865653105`*^9}, 3.549645547558117*^9, {
   3.5496463447007113`*^9, 3.549646355355321*^9}, {3.5496466849211707`*^9, 
   3.5496466921365833`*^9}, {3.5496468578500614`*^9, 3.5496468918720074`*^9}, 
   3.549647036359272*^9, {3.549647196360423*^9, 3.5496472252240744`*^9}, {
   3.549648493101593*^9, 3.549648505074278*^9}, {3.5496485865129356`*^9, 
   3.549648611179346*^9}, {3.549650042529215*^9, 3.5496500777682304`*^9}, {
   3.549650112487216*^9, 3.5496501493313236`*^9}, {3.549711703401063*^9, 
   3.549711731126649*^9}, {3.5497125034358225`*^9, 3.5497125101662073`*^9}, {
   3.549712597736216*^9, 3.5497126011884136`*^9}, {3.549713026234725*^9, 
   3.54971311199263*^9}, {3.5497131668007646`*^9, 3.5497132663154564`*^9}, {
   3.5497133224486675`*^9, 3.549713388088422*^9}, {3.5497134278776975`*^9, 
   3.549713431455902*^9}, {3.549713588559888*^9, 3.549713600378564*^9}, {
   3.5497138301347055`*^9, 3.5497138437314825`*^9}, {3.549714007428846*^9, 
   3.549714028080027*^9}, 3.5497240569656467`*^9, {3.5497271134574676`*^9, 
   3.549727113793487*^9}, {3.5497327715950937`*^9, 3.5497327935363483`*^9}, {
   3.5497330584715023`*^9, 3.5497331014589605`*^9}, {3.549733751039115*^9, 
   3.5497337556983814`*^9}, {3.549733979682192*^9, 3.5497339866845927`*^9}, {
   3.5497342090193095`*^9, 3.5497342122874966`*^9}, {3.5497346937890368`*^9, 
   3.5497347032565784`*^9}, {3.5497360090202637`*^9, 
   3.5497360217259903`*^9}, {3.5497361524334664`*^9, 
   3.5497361573507476`*^9}, {3.5497362972007465`*^9, 3.549736300686946*^9}, {
   3.5497364084021072`*^9, 3.549736412005313*^9}, {3.549802846032355*^9, 
   3.549802851313657*^9}, {3.549802983329208*^9, 3.549802987893469*^9}, {
   3.549803029943874*^9, 3.549803035187174*^9}, {3.5498032024647417`*^9, 
   3.549803206683983*^9}, {3.549811830829256*^9, 3.549811832372344*^9}, {
   3.5498123956745634`*^9, 3.549812411366461*^9}, {3.5498125437490325`*^9, 
   3.5498125796460857`*^9}, {3.5498126617547817`*^9, 
   3.5498126659090195`*^9}, {3.549812731907795*^9, 3.5498127354349966`*^9}, {
   3.5498164588129616`*^9, 3.5498164927039*^9}, {3.5498167746530266`*^9, 
   3.5498167784992466`*^9}, {3.5498169490710025`*^9, 
   3.5498169745064573`*^9}, {3.5498173801786604`*^9, 
   3.5498173964015884`*^9}, {3.5498181797313924`*^9, 3.549818192121101*^9}, {
   3.5498189150864525`*^9, 3.549818946795266*^9}, {3.550247298702488*^9, 
   3.550247311148199*^9}, {3.550251696318017*^9, 3.5502517175522313`*^9}, {
   3.5502517482999897`*^9, 3.550251753951313*^9}, {3.5505789682114754`*^9, 
   3.5505790032194777`*^9}, {3.550579174648283*^9, 3.550579176224373*^9}, 
   3.550579305062742*^9, {3.5505802245103316`*^9, 3.5505804043616185`*^9}, {
   3.55058043516438*^9, 3.550580438737585*^9}, {3.550580477658811*^9, 
   3.5505805339670315`*^9}, {3.550581013216443*^9, 3.550581026200186*^9}, {
   3.5505826373943405`*^9, 3.550582679467747*^9}, {3.5505827148947735`*^9, 
   3.5505828686635685`*^9}, {3.5521539961619434`*^9, 3.552154006000506*^9}, {
   3.552240918921979*^9, 3.55224093641698*^9}, {3.552389872378104*^9, 
   3.5523898808795905`*^9}, 3.552389957678983*^9, 3.552392073588006*^9, {
   3.5524043375500336`*^9, 3.552404343849394*^9}, {3.5524045019904394`*^9, 
   3.552404526604847*^9}, {3.552755062968752*^9, 3.5527550632717695`*^9}, 
   3.5552585139977694`*^9, 3.555259351461669*^9, {3.5559348718412886`*^9, 
   3.555934873428379*^9}, {3.5560213532162137`*^9, 3.5560213728323355`*^9}, {
   3.55602141661084*^9, 3.5560214805764985`*^9}, {3.556022720028391*^9, 
   3.556022741814637*^9}, {3.556023535881055*^9, 3.55602354156238*^9}, 
   3.556024586180129*^9, 3.556030238057398*^9, {3.556296027847335*^9, 
   3.5562960481294947`*^9}, 3.5562974878798437`*^9, {3.5562976604897165`*^9, 
   3.5562976936896152`*^9}, {3.556297864281042*^9, 3.556297867683236*^9}, {
   3.5562980449266596`*^9, 3.556298048336664*^9}, 3.559474535797535*^9, {
   3.5594809237458706`*^9, 3.5594809543835144`*^9}, {3.5594810073932967`*^9, 
   3.5594810962050295`*^9}, {3.5595060815485353`*^9, 
   3.5595060841676855`*^9}, {3.5595070730528727`*^9, 3.559507076400064*^9}, {
   3.559507118681712*^9, 3.559507122410119*^9}, {3.559507319073245*^9, 
   3.55950732785606*^9}, {3.5599436291567917`*^9, 3.5599436318667955`*^9}, 
   3.5599453778785925`*^9, 3.5600094971788516`*^9, {3.560010222392832*^9, 
   3.560010223204033*^9}, 3.5600102641305847`*^9, {3.560010898842888*^9, 
   3.5600109060012975`*^9}, {3.560010997115509*^9, 3.56001100150476*^9}, {
   3.5600110948620996`*^9, 3.560011103319583*^9}, {3.5600115117059417`*^9, 
   3.560011517026246*^9}, {3.5600285206664295`*^9, 3.560028552483249*^9}, {
   3.5600286504008493`*^9, 3.560028783992491*^9}, {3.5600289159400377`*^9, 
   3.560029044174372*^9}, {3.5600293961805058`*^9, 3.560029402460865*^9}, {
   3.5600295807630634`*^9, 3.5600295855683384`*^9}, {3.5600296956996374`*^9, 
   3.560029696056658*^9}, {3.560029851077524*^9, 3.5600298523245955`*^9}, {
   3.56003000293021*^9, 3.56003000346424*^9}, {3.560030196748296*^9, 
   3.5600301977703543`*^9}, {3.5600303477859344`*^9, 3.560030347933943*^9}, {
   3.560030631207145*^9, 3.5600306313511534`*^9}, {3.5600312619772234`*^9, 
   3.5600312649683943`*^9}, {3.560031873998229*^9, 3.5600318843238196`*^9}, {
   3.5600857705172415`*^9, 3.5600858477786603`*^9}, {3.560091821772031*^9, 
   3.5600918303985243`*^9}, 3.560103364085464*^9, 3.5601042984819083`*^9, {
   3.56018602488393*^9, 3.5601860309352765`*^9}, {3.5601861701082363`*^9, 
   3.5601861786377244`*^9}, {3.560186304203906*^9, 3.560186308180134*^9}, {
   3.5602515025988855`*^9, 3.560251523949106*^9}, {3.5602522776302147`*^9, 
   3.5602522943971734`*^9}, {3.5602530142913485`*^9, 
   3.5602530176225395`*^9}, {3.5602718117460933`*^9, 
   3.5602718365969367`*^9}, {3.560272354599143*^9, 3.560272369621969*^9}, {
   3.56027403542198*^9, 3.5602740354689827`*^9}, {3.5602754443881845`*^9, 
   3.560275449156458*^9}, {3.5602756071484947`*^9, 3.5602756129768276`*^9}, {
   3.560275862697589*^9, 3.5602758675118647`*^9}, {3.5602761872273674`*^9, 
   3.5602762014421806`*^9}, {3.560285256989397*^9, 3.560285294460663*^9}, {
   3.560285436444273*^9, 3.5602854480079346`*^9}, {3.560285478239664*^9, 
   3.5602854844900217`*^9}, {3.5602859650836735`*^9, 3.560285969185908*^9}, {
   3.5602860023668056`*^9, 3.5602860280162725`*^9}, {3.560286171715806*^9, 
   3.5602861777558146`*^9}, {3.560286786352542*^9, 3.5602868037821674`*^9}, {
   3.5603517214921856`*^9, 3.5603517262444572`*^9}, {3.560353561927496*^9, 
   3.5603535620755043`*^9}, {3.5603537194285045`*^9, 
   3.5603537257868137`*^9}, {3.5603538007133865`*^9, 3.560353808667842*^9}, {
   3.5605113328230243`*^9, 3.5605113363532257`*^9}, {3.5605114272704268`*^9, 
   3.5605114313856616`*^9}, {3.5605115088510923`*^9, 
   3.5605115127973185`*^9}, {3.560512944607213*^9, 3.5605129904348345`*^9}, {
   3.560513120854294*^9, 3.5605131244735007`*^9}, {3.5605131941084833`*^9, 
   3.560513197522679*^9}, {3.5605136986973443`*^9, 3.5605137210606236`*^9}, {
   3.5605138252815847`*^9, 3.5605138296358337`*^9}, {3.5605138925602417`*^9, 
   3.56051389742745*^9}, {3.5605239356525884`*^9, 3.5605239426099863`*^9}, {
   3.560525660588249*^9, 3.560525675309091*^9}, 3.56052609314499*^9, {
   3.5605265188703403`*^9, 3.560526527492833*^9}, 3.560526920971339*^9, 
   3.5605273020331345`*^9, {3.560528229507183*^9, 3.560528234749483*^9}, {
   3.5605283237655745`*^9, 3.560528327276775*^9}, {3.560528921412758*^9, 
   3.5605289240329075`*^9}, {3.560535976825305*^9, 3.5605359997036133`*^9}, {
   3.560536079065153*^9, 3.5605361014364324`*^9}, {3.5605361413297143`*^9, 
   3.560536151028269*^9}, {3.5605362142848873`*^9, 3.5605362156249638`*^9}, {
   3.5605364657412696`*^9, 3.5605364668503327`*^9}, 3.5605369588474736`*^9, {
   3.560540689958*^9, 3.5605406970872126`*^9}, 3.560540878353962*^9, {
   3.560541615019598*^9, 3.5605416192940054`*^9}, {3.5605421299859524`*^9, 
   3.5605421445757866`*^9}, {3.560542340255171*^9, 3.560542340649194*^9}, {
   3.5605425267937307`*^9, 3.560542529759735*^9}, {3.560542916920251*^9, 
   3.560542950893503*^9}, {3.560542980985956*^9, 3.5605430479412737`*^9}, {
   3.5605431054117746`*^9, 3.560543192912328*^9}, {3.5605432512876306`*^9, 
   3.5605432642824535`*^9}, {3.5605432951081076`*^9, 3.560543321530365*^9}, {
   3.5605434258953342`*^9, 3.5605434315376573`*^9}, {3.5605436080689206`*^9, 
   3.560543631685762*^9}, {3.560603124490102*^9, 3.560603133600623*^9}, {
   3.560603274624689*^9, 3.560603287694437*^9}, {3.5606038317085524`*^9, 
   3.5606038686176634`*^9}, {3.5606055157758756`*^9, 3.560605519937114*^9}, {
   3.560609721932454*^9, 3.5606097260646906`*^9}, {3.560610359340912*^9, 
   3.5606103740617537`*^9}, {3.56061042154847*^9, 3.560610426872774*^9}, {
   3.5606109255762987`*^9, 3.5606109453854313`*^9}, {3.5606112732361836`*^9, 
   3.5606112856628942`*^9}, {3.5606137970743985`*^9, 
   3.5606138008526144`*^9}, {3.5606145642052755`*^9, 
   3.5606145648943152`*^9}, {3.5606148317565784`*^9, 3.5606148542368646`*^9}, 
   3.560615635991578*^9, 3.56063331619444*^9, 3.5606334384080315`*^9, {
   3.5606341996562295`*^9, 3.5606342439135075`*^9}, {3.56063436435708*^9, 
   3.5606343991360693`*^9}, {3.560635006301233*^9, 3.560635031725272*^9}, {
   3.560635201685475*^9, 3.560635208315484*^9}, {3.560635471267967*^9, 
   3.5606354952764096`*^9}, {3.5606369194574347`*^9, 
   3.5606369274446487`*^9}, {3.5607193501364827`*^9, 
   3.5607193616381407`*^9}, {3.5607196528927994`*^9, 3.5607196546509*^9}, {
   3.5607199625593066`*^9, 3.560719987815751*^9}, {3.560720064021885*^9, 
   3.560720090448331*^9}, {3.560720935067073*^9, 3.5607209457756853`*^9}, {
   3.5607210091693115`*^9, 3.560721023739145*^9}, {3.560721104564768*^9, 
   3.5607211095360518`*^9}, {3.5607212135109987`*^9, 
   3.5607212263287325`*^9}, {3.5613970890566244`*^9, 3.561397160585716*^9}, {
   3.561398017792745*^9, 3.5613980203498917`*^9}, {3.5613981058147798`*^9, 
   3.561398107345867*^9}, {3.5613981510083647`*^9, 3.5613982701041765`*^9}, {
   3.5614019769191475`*^9, 3.561402053592533*^9}, {3.5648532250135374`*^9, 
   3.564853245060684*^9}, {3.5648551999364967`*^9, 3.5648552264430127`*^9}, {
   3.564855329530909*^9, 3.5648553454498196`*^9}, {3.564855481033574*^9, 
   3.5648554994776297`*^9}, {3.564857051767415*^9, 3.5648570558546495`*^9}, {
   3.564857088510517*^9, 3.5648571203023353`*^9}, {3.5648654415529523`*^9, 
   3.5648655209804955`*^9}, {3.564865586957269*^9, 3.564865598618936*^9}, {
   3.564865657032277*^9, 3.5648656729451876`*^9}, {3.564865725528195*^9, 
   3.5648657343536997`*^9}, {3.5648657757340665`*^9, 
   3.5648657964702525`*^9}, {3.5648659310189486`*^9, 3.56486596269576*^9}, {
   3.5648676871313925`*^9, 3.564867691161623*^9}, {3.5657065578314743`*^9, 
   3.565706563369484*^9}, {3.565707244040679*^9, 3.5657072491106877`*^9}, {
   3.565708825586258*^9, 3.5657088310785723`*^9}, {3.5657096529855824`*^9, 
   3.5657096592209387`*^9}, {3.5657130353109016`*^9, 3.565713039946167*^9}, {
   3.5657152034215775`*^9, 3.565715208857888*^9}, {3.565717599081601*^9, 
   3.5657176038518744`*^9}, {3.565718018525592*^9, 3.5657180397778077`*^9}, {
   3.5657186948172736`*^9, 3.5657186987524986`*^9}, {3.565723161624967*^9, 
   3.565723166991377*^9}, {3.565725420739029*^9, 3.5657254255523043`*^9}, {
   3.565725565365301*^9, 3.565725598829215*^9}, {3.565725646257928*^9, 
   3.5657256548724203`*^9}, {3.5657259899525857`*^9, 
   3.5657260002241735`*^9}, {3.5657262094181385`*^9, 3.565726213597378*^9}, {
   3.565726993260972*^9, 3.5657269968351765`*^9}, {3.5657272409071364`*^9, 
   3.5657272451203775`*^9}, {3.566043640560302*^9, 3.5660436619947395`*^9}, {
   3.5661492515818977`*^9, 3.5661492571002135`*^9}, {3.569627151796133*^9, 
   3.5696271583125057`*^9}, {3.5696273511265345`*^9, 3.569627380729227*^9}, {
   3.569627454953473*^9, 3.569627535307069*^9}, {3.5696282621126394`*^9, 
   3.569628286029008*^9}, {3.569628477666969*^9, 3.5696285222825203`*^9}, 
   3.5696288445589533`*^9, {3.569628877098815*^9, 3.5696288955728717`*^9}, {
   3.569946741288313*^9, 3.5699467498148003`*^9}, {3.5775564560304503`*^9, 
   3.577556471160472*^9}, {3.577556527690551*^9, 3.577556528570552*^9}, {
   3.5775603546600604`*^9, 3.577560359300067*^9}, {3.5775604453426895`*^9, 
   3.5775604502626963`*^9}, {3.5775605242133007`*^9, 
   3.5775605280133057`*^9}, {3.5775605700533648`*^9, 3.577560572943369*^9}, {
   3.577560613703426*^9, 3.577560618643433*^9}, {3.577618368305851*^9, 
   3.577618415395917*^9}, {3.577618464216985*^9, 3.577618509219552*^9}, {
   3.5776185438996005`*^9, 3.577618548669607*^9}, {3.5776186182863464`*^9, 
   3.5776186234163537`*^9}, {3.615568166025161*^9, 3.6155682062524614`*^9}, {
   3.6155682831358585`*^9, 3.6155683149166765`*^9}, {3.615568461514062*^9, 
   3.6155685477749953`*^9}, {3.6155687017378016`*^9, 
   3.6155687315605073`*^9}, {3.6155690870368395`*^9, 
   3.6155691248059998`*^9}, {3.6155691997322855`*^9, 3.615569200565333*^9}, {
   3.6155694035619435`*^9, 3.615569405300043*^9}, {3.6155694617702727`*^9, 
   3.6155694625643187`*^9}, {3.615569514654298*^9, 3.615569515859367*^9}, 
   3.615573517160228*^9, {3.615573549703089*^9, 3.615573562946847*^9}, {
   3.615573777327109*^9, 3.6155737946140976`*^9}, 3.615573839381658*^9, 
   3.6155831033127356`*^9, {3.615583143554037*^9, 3.6155831454571457`*^9}, {
   3.6155842511073856`*^9, 3.6155843117858562`*^9}, {3.6155843440557017`*^9, 
   3.615584344830746*^9}, {3.6155845110992565`*^9, 3.61558455417772*^9}, {
   3.6155848971868067`*^9, 3.6155848975468273`*^9}, {3.6155849397942367`*^9, 
   3.615584939890242*^9}, {3.615585062465251*^9, 3.615585098301301*^9}, {
   3.6155851424168243`*^9, 3.615585231775935*^9}, 3.615586108859145*^9, {
   3.6155863835466423`*^9, 3.6155863854657516`*^9}, {3.615586603479205*^9, 
   3.615586649693843*^9}, {3.6155867354437313`*^9, 3.6155867648274097`*^9}, {
   3.61558680330061*^9, 3.615586885141282*^9}, {3.6155876761705165`*^9, 
   3.6155877089363904`*^9}, {3.6155882095960035`*^9, 
   3.6155882417188406`*^9}, {3.615588479160204*^9, 3.6155884796342044`*^9}, {
   3.615588584417903*^9, 3.615588584513909*^9}, {3.6155888510326753`*^9, 
   3.6155888755654793`*^9}, 3.6155890205648317`*^9, {3.6156357007330275`*^9, 
   3.615635706961384*^9}, 3.6156357387082*^9, 3.6156358944481077`*^9, {
   3.615635970333448*^9, 3.6156359715085154`*^9}, {3.6196369333553724`*^9, 
   3.619636933526973*^9}, 3.646929450347928*^9, 3.646929868870545*^9, {
   3.6482956318964047`*^9, 3.648295655918705*^9}, {3.648304618622161*^9, 
   3.648304619645164*^9}, {3.6509916037968345`*^9, 3.650991614648974*^9}, {
   3.6509964368634405`*^9, 3.6509964372304616`*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"1e93a8ac-44ff-4ac9-9b2c-f4f3e1d768e3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Steady State", "Subsection",
 CellChangeTimes->{{3.708380941185093*^9, 
  3.708380942577232*^9}},ExpressionUUID->"521d2405-beaa-4621-b279-\
7ef00b42a7c2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ssvalrule", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ass", "->", 
      RowBox[{"Log", "[", "abar", "]"}]}], ",", 
     RowBox[{"zss", "->", 
      RowBox[{"Log", "[", "zbar", "]"}]}], ",", 
     RowBox[{"pss", "->", 
      RowBox[{"Log", "[", "pbar", "]"}]}], ",", 
     RowBox[{"rstarss", "->", "rbar"}], ",", 
     RowBox[{"ess", "->", 
      RowBox[{"Log", "[", "ebar", "]"}]}], ",", 
     RowBox[{"dss", "->", "0"}], ",", 
     RowBox[{"qss", "->", "0"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.883756653977003*^9, 3.883756668873044*^9}, {
   3.8848989126305075`*^9, 3.8848989137808113`*^9}, {3.896550268365389*^9, 
   3.896550292539571*^9}, 3.8965669557676077`*^9, {3.8968215867192755`*^9, 
   3.896821609984545*^9}, {3.896821829358255*^9, 3.8968218500989914`*^9}, {
   3.897518935563108*^9, 3.8975189369589396`*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"d2b37efc-e70c-4037-9151-04fd2962b242"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["First Order Perturbation", "Section",
 CellChangeTimes->{{3.5493902160529375`*^9, 3.5493902210832253`*^9}, {
  3.7082806072930865`*^9, 
  3.7082806085732145`*^9}},ExpressionUUID->"e734adf6-27c3-4415-9ee0-\
f1997e0401a8"],

Cell[CellGroupData[{

Cell["Variables", "Subsection",
 CellChangeTimes->{{3.5359998681475763`*^9, 
  3.5359998712187524`*^9}},ExpressionUUID->"4679d204-8bdc-41f4-818c-\
3a29e20504cf"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"G", "[", "s", "]"}], "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"yvars", "/.", "funrulei"}], ",", 
      RowBox[{"{", "state", "}"}]}], "]"}], "/.", "derivrule"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H", "[", "s", "]"}], "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"xvars", "/.", "funrulei"}], ",", 
      RowBox[{"{", "state", "}"}]}], "]"}], "/.", "derivrule"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"G", "[", "sp", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"yvars", "/.", "funrulei"}], ",", 
       RowBox[{"{", "state", "}"}]}], "]"}], "/.", "derivrule"}], "/.", 
    RowBox[{"s", "\[Rule]", "sp"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5353019150511136`*^9, 3.5353019308660183`*^9}, {
   3.5353019614677687`*^9, 3.5353020271875277`*^9}, {3.5354069250532503`*^9, 
   3.53540692841225*^9}, 3.5359985564395514`*^9, {3.535998641614423*^9, 
   3.535998657139311*^9}, {3.5359987911109734`*^9, 3.5359988261739793`*^9}, {
   3.5359990426533613`*^9, 3.53599904350841*^9}, 3.5359998529197054`*^9, {
   3.5359999255968623`*^9, 3.535999962824992*^9}, 3.536001868987018*^9, {
   3.53600438261679*^9, 3.5360043961835656`*^9}, {3.5360051178178406`*^9, 
   3.536005118695891*^9}, {3.536005299919256*^9, 3.5360053106048675`*^9}, {
   3.536005371769366*^9, 3.536005374864543*^9}, {3.5496406768615294`*^9, 
   3.5496406775265675`*^9}, {3.560609818418973*^9, 3.560609825204361*^9}, {
   3.5606099506755376`*^9, 3.5606099547007675`*^9}, {3.60976580746196*^9, 
   3.6097658205219784`*^9}, {3.6097684278905125`*^9, 
   3.6097684370340137`*^9}, {3.609776362833999*^9, 3.6097764592095118`*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"ce50f43c-4d92-4c9a-90f6-08035e7ec88f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for x", "Subsection",
 CellChangeTimes->{{3.549639283931858*^9, 3.549639289528178*^9}, {
   3.549640669619115*^9, 3.549640671001194*^9}, {3.6097684200580816`*^9, 
   3.6097684211761427`*^9}, 3.609769401689104*^9, {3.6098557940084286`*^9, 
   3.609855794712468*^9}},ExpressionUUID->"3ea0882f-cf49-4fba-8602-\
4680e3e26fd9"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dfx", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"f", ",", 
         RowBox[{"{", "xlag", "}"}]}], "]"}], "/.", "ssrule"}], "/.", 
      "derivrule"}], "/.", "ssvalrule"}], "/.", "epsrule"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", "nx"}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Btemp", "[", "ii", "]"}], ",", "Atemp"}], "}"}], "=", 
      RowBox[{"CoefficientArrays", "[", 
       RowBox[{
        RowBox[{"dfx", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"1", ";;", "n"}], ",", "ii"}], "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"H", "[", "s", "]"}], "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"1", ";;", "nx"}], ",", "ii"}], "]"}], "]"}]}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Atemp1", "[", "ii", "]"}], ",", "Atemp2"}], "}"}], "=", 
      RowBox[{"CoefficientArrays", "[", 
       RowBox[{
        RowBox[{"Normal", "[", 
         RowBox[{"Atemp", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"1", ";;", "n"}], ",", "ii"}], "]"}], "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"G", "[", "sp", "]"}], "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"1", ";;", "ny"}], ",", "ii"}], "]"}], "]"}]}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Btemp1", "[", "ii", "]"}], ",", "Btemp2"}], "}"}], "=", 
      RowBox[{"CoefficientArrays", "[", 
       RowBox[{
        RowBox[{"Normal", "[", 
         RowBox[{"Btemp", "[", "ii", "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"G", "[", "s", "]"}], "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"1", ";;", "ny"}], ",", "ii"}], "]"}], "]"}]}], "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"A", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"1", ";;", "n"}], ",", "ii"}], "]"}], "]"}], "=", 
      RowBox[{"Normal", "[", 
       RowBox[{"Atemp1", "[", "ii", "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"B", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"1", ";;", "n"}], ",", "ii"}], "]"}], "]"}], "=", 
      RowBox[{"Normal", "[", 
       RowBox[{"Btemp1", "[", "ii", "]"}], "]"}]}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"1", ";;", "n"}], ",", 
      RowBox[{
       RowBox[{"nx", "+", "1"}], ";;", "n"}]}], "]"}], "]"}], "=", 
   RowBox[{"Normal", "[", "Atemp2", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"B", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"1", ";;", "n"}], ",", 
      RowBox[{
       RowBox[{"nx", "+", "1"}], ";;", "n"}]}], "]"}], "]"}], "=", 
   RowBox[{"Normal", "[", "Btemp2", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Norm", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"dfx", "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"A", ".", 
         RowBox[{"Join", "[", 
          RowBox[{
           RowBox[{"IdentityMatrix", "[", "nx", "]"}], ",", 
           RowBox[{
            RowBox[{"G", "[", "sp", "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"1", ";;", "ny"}], ",", 
              RowBox[{"1", ";;", "nx"}]}], "]"}], "]"}]}], "]"}], ".", 
         RowBox[{
          RowBox[{"H", "[", "s", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"1", ";;", "nx"}], ",", 
            RowBox[{"1", ";;", "nx"}]}], "]"}], "]"}]}], "+", 
        RowBox[{"B", ".", 
         RowBox[{"Join", "[", 
          RowBox[{
           RowBox[{"IdentityMatrix", "[", "nx", "]"}], ",", 
           RowBox[{
            RowBox[{"G", "[", "s", "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"1", ";;", "ny"}], ",", 
              RowBox[{"1", ";;", "nx"}]}], "]"}], "]"}]}], "]"}]}]}], ")"}]}],
      "]"}], "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6097632282004633`*^9, 3.6097632427512956`*^9}, {
   3.6097634360633106`*^9, 3.609763442542679*^9}, {3.6097634835260077`*^9, 
   3.6097634867421913`*^9}, {3.6097646364690943`*^9, 3.609764637676163*^9}, {
   3.6097649652667894`*^9, 3.6097649830588007`*^9}, 3.6097657447818727`*^9, {
   3.6097658427720094`*^9, 3.6097658443320117`*^9}, {3.6097684083594403`*^9, 
   3.6097684112576003`*^9}, 3.6097684511687913`*^9, {3.609769357626584*^9, 
   3.6097693907304773`*^9}, {3.6097696582327776`*^9, 3.609769661992993*^9}, {
   3.6097740383552775`*^9, 3.609774045601692*^9}, {3.6097748870046644`*^9, 
   3.609774888172731*^9}, {3.6097749551705427`*^9, 3.6097749642750635`*^9}, {
   3.6098539375274134`*^9, 3.609853943550758*^9}, {3.6098546689382477`*^9, 
   3.6098546770977144`*^9}, {3.6098547136818066`*^9, 
   3.6098547197451534`*^9}, {3.609855031968012*^9, 3.6098550321200204`*^9}, {
   3.609855817425759*^9, 3.6098558495835886`*^9}, {3.6098645760658092`*^9, 
   3.6098645792499914`*^9}, 3.6101050990285983`*^9, {3.610105403874539*^9, 
   3.610105405450142*^9}, {3.6249809460568256`*^9, 3.6249810094259176`*^9}, {
   3.624981057203988*^9, 3.6249811371571074`*^9}, {3.6249820712515955`*^9, 
   3.6249820738715987`*^9}, {3.6249850296427083`*^9, 
   3.6249850807988415`*^9}, {3.6249854665166187`*^9, 
   3.6249854793966365`*^9}, {3.62498561779486*^9, 3.624985642482895*^9}, {
   3.6249868708099947`*^9, 3.624986878510005*^9}, {3.624987067604289*^9, 
   3.6249870706742935`*^9}, {3.624987413445799*^9, 3.6249874143758*^9}, {
   3.624995956195182*^9, 3.624995957335183*^9}, {3.6250076867058015`*^9, 
   3.6250077802553177`*^9}, {3.6250078201365833`*^9, 
   3.6250079147042828`*^9}, {3.6250079869827166`*^9, 
   3.6250079916237507`*^9}, {3.6250082060685377`*^9, 3.625008224124852*^9}, {
   3.6250083294780807`*^9, 3.62500835013312*^9}, {3.6250085371833715`*^9, 
   3.625008605979201*^9}, {3.625008672471997*^9, 3.625008719880411*^9}, {
   3.625008808712904*^9, 3.6250088416350875`*^9}, {3.625008918030774*^9, 
   3.625008935704873*^9}, 3.625061730575107*^9, {3.6250624061252337`*^9, 
   3.6250624846864185`*^9}, {3.6250625664475985`*^9, 3.625062597314693*^9}, {
   3.625062832132291*^9, 3.625062880946415*^9}, {3.6265506863193765`*^9, 
   3.62655068799938*^9}, 3.626563233788453*^9, {3.626563424585679*^9, 
   3.6265634331856995`*^9}, 3.6265634979318237`*^9, 3.626563560867956*^9, {
   3.626620203462479*^9, 3.6266202294525366`*^9}, {3.626637001317552*^9, 
   3.6266370015175524`*^9}, {3.650922458541669*^9, 3.6509224690122676`*^9}, {
   3.6509906770909357`*^9, 3.650990677620939*^9}, {3.6521153009762135`*^9, 
   3.65211530113522*^9}, {3.7083539893493023`*^9, 3.7083539916133027`*^9}, {
   3.7083842513190885`*^9, 3.70838425283924*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"8e594fd7-1259-439a-9307-e712fe5c1bf9"],

Cell[BoxData["0"], "Print",
 CellChangeTimes->{
  3.8626607965383196`*^9, 3.8626617292968645`*^9, 3.8626694723027945`*^9, 
   3.8626704805523443`*^9, 3.862670523702176*^9, 3.863535536269086*^9, 
   3.8635424393913574`*^9, 3.8726322424352255`*^9, 3.8837566935767236`*^9, 
   3.8837591993827343`*^9, 3.883869867136688*^9, 3.8838700290367856`*^9, 
   3.8839550932549124`*^9, 3.8839564653553267`*^9, 3.884271330068455*^9, 
   3.88489893229716*^9, 3.8849624713606462`*^9, 3.884964934239049*^9, 
   3.8849654404060507`*^9, 3.8849862407393613`*^9, 3.8856440098775606`*^9, 
   3.885646293385417*^9, 3.8965461921463227`*^9, 3.896546230863367*^9, 
   3.896550299391943*^9, 3.8965661518224735`*^9, 3.8965669738600616`*^9, 
   3.896567310034226*^9, {3.896567386788171*^9, 3.896567400592067*^9}, 
   3.896800829543198*^9, 3.8968021184635253`*^9, 3.896807893824232*^9, 
   3.8968216655340014`*^9, 3.8968218607359037`*^9, 3.89682392756863*^9, 
   3.8968242223144913`*^9, 3.8968950080186577`*^9, 3.896913116559521*^9, 
   3.896914412688346*^9, 3.896981239054038*^9, 3.8969816334609375`*^9, 
   3.897238118201226*^9, 3.897238880710946*^9, 3.8973971998568606`*^9, 
   3.897426477208349*^9, 3.8975189440094585`*^9, 3.8975810233477283`*^9, 
   3.8977724407397194`*^9, 3.9011919422238903`*^9},
 CellLabel->
  "During evaluation of \
In[72]:=",ExpressionUUID->"facd3d71-6e94-4bbe-a9f4-d53651c4ef4b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for \[Epsilon]", "Subsection",
 CellChangeTimes->{{3.625009110820198*^9, 
  3.6250091151812277`*^9}},ExpressionUUID->"f0e8c21b-5d6f-46dd-85cf-\
b403e7586209"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"D\[Epsilon]", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "ne"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"df\[Epsilon]", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"f", ",", 
         RowBox[{"{", "eps", "}"}]}], "]"}], "/.", "ssrule"}], "/.", 
      "derivrule"}], "/.", "ssvalrule"}], "/.", "epsrule"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", "ne"}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"d\[Epsilon]vars", "=", 
      RowBox[{"Flatten", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"H", "[", "s", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"1", ";;", "nx"}], ",", 
            RowBox[{"nx", "+", "ii"}]}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"G", "[", "s", "]"}], "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"1", ";;", "ny"}], ",", 
            RowBox[{"nx", "+", "ii"}]}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"D\[Epsilon]part", "[", "ii", "]"}], ",", "C\[Epsilon]"}], 
       "}"}], "=", 
      RowBox[{"CoefficientArrays", "[", 
       RowBox[{
        RowBox[{"df\[Epsilon]", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{"1", ";;", "n"}], ",", "ii"}], "]"}], "]"}], ",", 
        "d\[Epsilon]vars"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"D\[Epsilon]", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"1", ";;", "n"}], ",", 
         RowBox[{"ii", ";;", "ii"}]}], "]"}], "]"}], "=", 
      RowBox[{"Normal", "[", 
       RowBox[{"D\[Epsilon]part", "[", "ii", "]"}], "]"}]}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Norm", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"df\[Epsilon]", "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"C\[Epsilon]", ".", 
         RowBox[{"Join", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"H", "[", "s", "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"1", ";;", "nx"}], ",", 
              RowBox[{
               RowBox[{"nx", "+", "1"}], ";;", 
               RowBox[{"nx", "+", "ne"}]}]}], "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"G", "[", "s", "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"1", ";;", "ny"}], ",", 
              RowBox[{
               RowBox[{"nx", "+", "1"}], ";;", 
               RowBox[{"nx", "+", "ne"}]}]}], "]"}], "]"}]}], "]"}]}], "+", 
        "D\[Epsilon]"}], ")"}]}], "]"}], "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6098558382499437`*^9, 3.6098558386339655`*^9}, 
   3.6098580622499332`*^9, {3.6098645717145605`*^9, 3.609864573650671*^9}, 
   3.6101051001206007`*^9, 3.61010541030175*^9, {3.624981012738923*^9, 
   3.6249810134589243`*^9}, {3.6249865999945707`*^9, 3.624986601344573*^9}, {
   3.624987303146639*^9, 3.62498730375664*^9}, {3.6249879722112155`*^9, 
   3.6249879724312153`*^9}, {3.624988069454569*^9, 3.6249880695945687`*^9}, {
   3.6249901690936975`*^9, 3.6249901701237*^9}, {3.6249902214308176`*^9, 
   3.624990222737821*^9}, {3.6249906346178694`*^9, 3.624990637657875*^9}, {
   3.624990739416128*^9, 3.624990759081175*^9}, {3.6249908612054763`*^9, 
   3.6249908722185*^9}, {3.6249909681207776`*^9, 3.6249910176479063`*^9}, {
   3.624995980182232*^9, 3.6249960030653095`*^9}, {3.6249961640116773`*^9, 
   3.624996196638769*^9}, {3.6250021804021144`*^9, 3.625002201457144*^9}, {
   3.625002336478916*^9, 3.625002359770313*^9}, {3.6250024479417896`*^9, 
   3.625002571281414*^9}, {3.625002692558586*^9, 3.6250027161436195`*^9}, 
   3.6250028672055635`*^9, {3.6250029160609846`*^9, 3.625002917020986*^9}, {
   3.6250029588211317`*^9, 3.625002972839347*^9}, 3.6250041890751977`*^9, {
   3.6250042298152547`*^9, 3.625004264125304*^9}, {3.6250045322713504`*^9, 
   3.625004570451406*^9}, {3.625004650086748*^9, 3.6250046770467863`*^9}, {
   3.625004734236869*^9, 3.625004802469967*^9}, {3.6250087653266573`*^9, 
   3.6250087668096666`*^9}, 3.6265485721198807`*^9, {3.626560369502477*^9, 
   3.626560370662503*^9}, 3.626563241508464*^9, {3.626563893462827*^9, 
   3.6265638974158335`*^9}, {3.626637019019577*^9, 3.6266370192195773`*^9}, {
   3.627395102067086*^9, 3.627395108349121*^9}, {3.6273965916398754`*^9, 
   3.6273965959511223`*^9}, 3.650922524500002*^9, 3.650990684683964*^9, 
   3.6521153127856555`*^9, {3.7083539944603024`*^9, 3.7083539963643026`*^9}, 
   3.8969818135355816`*^9},
 CellLabel->"In[79]:=",ExpressionUUID->"1f8bbd5a-7ab7-495f-9cce-7f77e235a854"],

Cell[BoxData["0"], "Print",
 CellChangeTimes->{3.8965669803790874`*^9, 3.8965673175350676`*^9, 
  3.8965674050440407`*^9, 3.8968008338606043`*^9, 3.896802121513883*^9, 
  3.896807897534239*^9, 3.896821669202911*^9, 3.8968218664708853`*^9, 
  3.896823931279702*^9, 3.896824225458563*^9, 3.8968950118994884`*^9, 
  3.8969131203329287`*^9, 3.896914416769929*^9, 3.896981242319254*^9, 
  3.8969816374069424`*^9, 3.8969818201116085`*^9, 3.8972381206749077`*^9, 
  3.897238883663109*^9, 3.897397204295488*^9, 3.897426481462263*^9, 
  3.897518946963947*^9, 3.897581025898946*^9, 3.897772444832857*^9, 
  3.9011919453009157`*^9},
 CellLabel->
  "During evaluation of \
In[79]:=",ExpressionUUID->"680c8b80-8bee-4074-842f-2bfbe4b1c4b4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for \[Chi]", "Subsection",
 CellChangeTimes->{{3.6097760372983828`*^9, 3.6097760397145214`*^9}, {
  3.609858092943689*^9, 
  3.6098580953438263`*^9}},ExpressionUUID->"45a0097f-15f9-48d1-a209-\
f05e39a2f953"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"df\[Chi]", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"f", ",", 
          RowBox[{"{", "\[Chi]", "}"}]}], "]"}], "/.", "ssrule"}], "/.", 
       "derivrule"}], "/.", "ssvalrule"}], "/.", "epsprule1"}], "/.", 
    "epsrule"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d\[Chi]vars", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"H", "[", "s", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"1", ";;", "nx"}], ",", 
         RowBox[{"nx", "+", "ne", "+", "1"}]}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{"G", "[", "s", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"1", ";;", "ny"}], ",", 
         RowBox[{"nx", "+", "ne", "+", "1"}]}], "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{"G", "[", "sp", "]"}], "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"1", ";;", "ny"}], ",", 
         RowBox[{"nx", "+", "ne", "+", "1"}]}], "]"}], "]"}]}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"D\[Chi]", ",", "C\[Chi]"}], "}"}], "=", 
   RowBox[{"CoefficientArrays", "[", 
    RowBox[{"df\[Chi]", ",", "d\[Chi]vars"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Norm", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"df\[Chi]", "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"C\[Chi]", ".", 
         RowBox[{"Join", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"H", "[", "s", "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"1", ";;", "nx"}], ",", 
              RowBox[{"nx", "+", "ne", "+", "1"}]}], "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"G", "[", "s", "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"1", ";;", "ny"}], ",", 
              RowBox[{"nx", "+", "ne", "+", "1"}]}], "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"G", "[", "sp", "]"}], "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"1", ";;", "ny"}], ",", 
              RowBox[{"nx", "+", "ne", "+", "1"}]}], "]"}], "]"}]}], "]"}]}], 
        "+", "D\[Chi]"}], ")"}]}], "]"}], "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.6250054821669407`*^9, 3.625005632511511*^9}, {
   3.6250056757035723`*^9, 3.6250056911535935`*^9}, {3.6250057331436524`*^9, 
   3.625005733673653*^9}, 3.6265485758868885`*^9, {3.6265516815368567`*^9, 
   3.626551701462901*^9}, {3.6265518412892466`*^9, 3.626551841719248*^9}, {
   3.6265518861253414`*^9, 3.62655189007835*^9}, {3.626559816966004*^9, 
   3.626559836500744*^9}, {3.6265598728911295`*^9, 3.6265598741471777`*^9}, {
   3.6265602824056644`*^9, 3.626560365635398*^9}, 3.626563242018464*^9, {
   3.626563453574736*^9, 3.626563467974762*^9}, {3.626636999337549*^9, 
   3.6266369995275497`*^9}, {3.6273950881130185`*^9, 3.6273950986160684`*^9}, 
   3.6509225686770782`*^9, 3.650990690253984*^9, 3.652115314316713*^9, {
   3.7083539992603025`*^9, 3.7083540013403025`*^9}, 3.896981815628934*^9},
 CellLabel->"In[83]:=",ExpressionUUID->"ae0f7142-a470-48a0-a6ed-9943a05b617c"],

Cell[BoxData["0"], "Print",
 CellChangeTimes->{3.8968218677237687`*^9, 3.8968239320451703`*^9, 
  3.896824226092702*^9, 3.896895012747359*^9, 3.8969131211022515`*^9, 
  3.8969144175978956`*^9, 3.8969812431058164`*^9, 3.896981638277076*^9, 
  3.8969818207141595`*^9, 3.8972381212076206`*^9, 3.8972388843186483`*^9, 
  3.897397205234909*^9, 3.897426482594484*^9, 3.8975189475656796`*^9, 
  3.897581026530241*^9, 3.897772446695036*^9, 3.901191946022112*^9},
 CellLabel->
  "During evaluation of \
In[83]:=",ExpressionUUID->"620839d2-7ea7-454a-8af6-f63987563d56"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Second Order Perturbation", "Section",
 CellChangeTimes->{{3.609854435314885*^9, 
  3.6098544394901237`*^9}},ExpressionUUID->"8a5b2199-1ba2-4a60-968d-\
35a057b1887d"],

Cell[CellGroupData[{

Cell["Exogenous First Order", "Subsection",
 CellChangeTimes->{{3.708377054306819*^9, 
  3.708377062138602*^9}},ExpressionUUID->"e95f4013-4cd0-4d81-be73-\
171d866f3eb4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dvars", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"xvars", "[", 
         RowBox[{"[", 
          RowBox[{"3", ";;", "nx"}], "]"}], "]"}], "/.", "funrulei"}], ",", 
       RowBox[{"{", "state", "}"}]}], "]"}], "/.", "derivrule"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"firstordersoln", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"Thread", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"D", "[", 
              RowBox[{
               RowBox[{"f", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"nendo", "+", "1"}], ";;", "n"}], "]"}], "]"}], ",", 
               RowBox[{"{", "state", "}"}]}], "]"}], "/.", "derivrule"}], "/.",
             "ssrule"}], "/.", "epsrule"}], "]"}], ")"}], "\[Equal]", "0"}], 
       "]"}], ",", "dvars"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"secondordersoln", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"Thread", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"D", "[", 
              RowBox[{
               RowBox[{"f", "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"nendo", "+", "1"}], ";;", "n"}], "]"}], "]"}], ",", 
               RowBox[{"{", "state", "}"}]}], "]"}], "/.", "derivrule"}], "/.",
             "ssrule"}], "/.", "epsrule"}], "]"}], ")"}], "\[Equal]", "0"}], 
       "]"}], ",", "dvars"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"prule", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"Pfun", "[", 
        RowBox[{"s", ",", "sp"}], "]"}], 
       TagBox[
        RowBox[{"(", 
         RowBox[{"2", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "\[Rule]", "0"}], ",", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Pfun", "[", 
        RowBox[{"s", ",", "sp"}], "]"}], 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "\[Rule]", "0"}], ",", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Pfun", "[", 
        RowBox[{"s", ",", "sp"}], "]"}], 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "2"}], ")"}],
        Derivative],
       MultilineFunction->None], "\[Rule]", "0"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8626616720280075`*^9, 3.8626616723396845`*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"ba21f123-23c8-45f5-a382-b4a9dd0a0c08"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Variables", "Subsection",
 CellChangeTimes->{{3.6101054953686996`*^9, 
  3.610105499019106*^9}},ExpressionUUID->"7f4271d6-c5ba-44f1-b493-\
f8fa92e16e8b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"G2", "[", "s", "]"}], "=", 
   RowBox[{
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"yvars", "/.", "funrulei"}], ",", 
         RowBox[{"{", 
          RowBox[{"state", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"nx", "+", "ne", "+", "1"}], ")"}], "2"]}], "]"}], "/.", 
    "derivrule"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"H2", "[", "s", "]"}], "=", 
   RowBox[{
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"xvars", "/.", "funrulei"}], ",", 
         RowBox[{"{", 
          RowBox[{"state", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"nx", "+", "ne", "+", "1"}], ")"}], "2"]}], "]"}], "/.", 
    "derivrule"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"G2", "[", "sp", "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Partition", "[", 
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"yvars", "/.", "funrulei"}], ",", 
          RowBox[{"{", 
           RowBox[{"state", ",", "2"}], "}"}]}], "]"}], "]"}], ",", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"nx", "+", "ne", "+", "1"}], ")"}], "2"]}], "]"}], "/.", 
     "derivrule"}], "/.", 
    RowBox[{"s", "\[Rule]", "sp"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h2", "[", "s", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"h2", "[", 
      RowBox[{"s", ",", "i", ",", "j"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "nx"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"nx", "+", "ne", "+", "1"}], ")"}], "2"]}], "}"}]}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g2", "[", "s", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"g2", "[", 
      RowBox[{"s", ",", "i", ",", "j"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "ny"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"nx", "+", "ne", "+", "1"}], ")"}], "2"]}], "}"}]}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g2", "[", "sp", "]"}], "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"g2", "[", 
      RowBox[{"sp", ",", "i", ",", "j"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "ny"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "1", ",", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"nx", "+", "ne", "+", "1"}], ")"}], "2"]}], "}"}]}], "]"}]}],
   ";"}]}], "Input",
 CellChangeTimes->{{3.6098544464435215`*^9, 3.609854505491899*^9}, {
  3.6098545613560944`*^9, 3.6098545616911135`*^9}, {3.6098546101068826`*^9, 
  3.6098546260357933`*^9}, {3.6250665046659365`*^9, 3.625066511005945*^9}, {
  3.625067495956772*^9, 3.6250675076367884`*^9}, {3.627153279409436*^9, 
  3.6271533439906483`*^9}, {3.627153449269067*^9, 3.6271534641991606`*^9}},
 CellLabel->"In[91]:=",ExpressionUUID->"46582390-4853-469a-8bb8-0d3a293195c2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for x, x", "Subsection",
 CellChangeTimes->{{3.609854658688661*^9, 3.6098546599207315`*^9}, {
  3.609855870103756*^9, 
  3.6098558734159455`*^9}},ExpressionUUID->"88c2e078-5a27-4541-84f1-\
d4b0dab7e2dc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"d2fxx", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dxxvars1", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dxxvars2", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dxxvars3", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", "nx"}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jj", "=", "1"}], ",", 
       RowBox[{"jj", "\[LessEqual]", "nx"}], ",", 
       RowBox[{"jj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"jj", "\[GreaterEqual]", "ii"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"d2fxx", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{"d2fxx", ",", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"D", "[", 
                    RowBox[{"F", ",", 
                    RowBox[{"{", 
                    RowBox[{"state", "[", 
                    RowBox[{"[", "ii", "]"}], "]"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"state", "[", 
                    RowBox[{"[", "jj", "]"}], "]"}], "}"}]}], "]"}], "/.", 
                    "derivrule"}], "/.", "ssrule"}], "/.", "ssvalrule"}], "/.",
                  "prule"}], "/.", "epsrule"}]}], "}"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"dxxvars1", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{"dxxvars1", ",", 
               RowBox[{
                RowBox[{"H2", "[", "s", "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"1", ";;", "nx"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                   "jj"}]}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"dxxvars2", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{"dxxvars2", ",", 
               RowBox[{
                RowBox[{"G2", "[", "s", "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"1", ";;", "ny"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                   "jj"}]}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"dxxvars3", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{"dxxvars3", ",", 
               RowBox[{
                RowBox[{"G2", "[", "sp", "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"1", ";;", "ny"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                   "jj"}]}], "]"}], "]"}]}], "}"}], "]"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"jj", "<", "ii"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"d2fxx", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{"d2fxx", ",", "\[IndentingNewLine]", 
               RowBox[{"Flatten", "[", 
                RowBox[{"Thread", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"H2", "[", "s", "]"}], "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"1", ";;", "nx"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                    "jj"}]}], "]"}], "]"}], "-", 
                  RowBox[{
                   RowBox[{"h2", "[", "s", "]"}], "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"1", ";;", "nx"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                    "jj"}]}], "]"}], "]"}]}], "]"}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Flatten", "[", 
                RowBox[{"Thread", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"G2", "[", "s", "]"}], "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"1", ";;", "ny"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                    "jj"}]}], "]"}], "]"}], "-", 
                  RowBox[{
                   RowBox[{"g2", "[", "s", "]"}], "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"1", ";;", "ny"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                    "jj"}]}], "]"}], "]"}]}], "]"}], "]"}]}], 
              "\[IndentingNewLine]", "}"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"dxxvars1", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{"dxxvars1", ",", 
               RowBox[{
                RowBox[{"h2", "[", "s", "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"1", ";;", "nx"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                   "jj"}]}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"dxxvars2", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{"dxxvars2", ",", 
               RowBox[{
                RowBox[{"g2", "[", "s", "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"1", ";;", "ny"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                   "jj"}]}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"dxxvars3", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{"dxxvars3", ",", 
               RowBox[{
                RowBox[{"g2", "[", "sp", "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"1", ";;", "ny"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                   "jj"}]}], "]"}], "]"}]}], "}"}], "]"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
     ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dxxvars", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"{", 
     RowBox[{"dxxvars1", ",", "dxxvars2", ",", "dxxvars3"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Nxx", ",", "Mxx"}], "}"}], "=", 
   RowBox[{"CoefficientArrays", "[", 
    RowBox[{"d2fxx", ",", "dxxvars"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"Norm", "[", 
      RowBox[{"Simplify", "[", 
       RowBox[{"d2fxx", "-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Mxx", ".", "dxxvars"}], "+", "Nxx"}], ")"}]}], "]"}], 
      "]"}], "]"}], ";"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.6250636277755356`*^9, 3.6250636468598285`*^9}, {
   3.625063682043436*^9, 3.625063720191961*^9}, {3.6250639698682537`*^9, 
   3.62506398910828*^9}, {3.626528076906588*^9, 3.6265282191159067`*^9}, {
   3.6265282553650074`*^9, 3.626528431554425*^9}, {3.626528467480505*^9, 
   3.6265285052435894`*^9}, {3.626529679843213*^9, 3.626529704813276*^9}, {
   3.6265303526870546`*^9, 3.6265304377781796`*^9}, {3.6265304751822357`*^9, 
   3.626530487874254*^9}, {3.626530528764312*^9, 3.6265306149004335`*^9}, {
   3.6265306601224976`*^9, 3.626530712127571*^9}, {3.626531040444271*^9, 
   3.6265310926003857`*^9}, {3.626531123907476*^9, 3.626531151873535*^9}, {
   3.6265374354340315`*^9, 3.6265374594800806`*^9}, {3.62653749418016*^9, 
   3.6265374960201635`*^9}, {3.626537563566331*^9, 3.6265375800293674`*^9}, {
   3.62653845364045*^9, 3.626538551859681*^9}, {3.6265385960197725`*^9, 
   3.626538608995826*^9}, {3.6265386506559095`*^9, 3.626538653795915*^9}, {
   3.6265403567584476`*^9, 3.626540377901491*^9}, {3.626540424454612*^9, 
   3.6265404750277233`*^9}, {3.626540508107797*^9, 3.6265405986870427`*^9}, {
   3.6265406466631775`*^9, 3.6265406520061884`*^9}, {3.626542247711773*^9, 
   3.626542264413796*^9}, {3.6265429495483136`*^9, 3.626542982155406*^9}, {
   3.6265430266185226`*^9, 3.626543082657637*^9}, {3.626543325219528*^9, 
   3.6265433288295355`*^9}, {3.6265434461388006`*^9, 
   3.6265436387542453`*^9}, {3.6265436992673736`*^9, 3.626543699427374*^9}, {
   3.6265453902664957`*^9, 3.6265454189625406`*^9}, {3.626545469229622*^9, 
   3.626545474332629*^9}, {3.6265457782663064`*^9, 3.6265457814093723`*^9}, 
   3.6265632427484655`*^9, {3.6265639060758505`*^9, 3.626563911605861*^9}, {
   3.626564603715069*^9, 3.626564603975069*^9}, {3.626734262156846*^9, 
   3.626734279563261*^9}, {3.626734763502101*^9, 3.626734775082354*^9}, 
   3.6271517631944304`*^9, {3.627153142015916*^9, 3.627153143325922*^9}, {
   3.6271531858571186`*^9, 3.627153231218281*^9}, {3.6271532660983944`*^9, 
   3.6271532670703983`*^9}, {3.627153330539604*^9, 3.627153495410307*^9}, 
   3.6271536135659485`*^9, {3.6271540615187635`*^9, 3.6271540891408024`*^9}, {
   3.627154226692998*^9, 3.627154234743009*^9}, {3.6271542784520707`*^9, 
   3.627154282502076*^9}, {3.627154798023751*^9, 3.6271547982037506`*^9}, {
   3.6271551588783293`*^9, 3.6271551689183435`*^9}, {3.6271552303184323`*^9, 
   3.627155232278435*^9}, 3.6509225785950923`*^9, 3.6509906952310014`*^9, {
   3.7082787856874113`*^9, 3.708278788585644*^9}, {3.7082791895729656`*^9, 
   3.7082791930411773`*^9}, {3.708362068776147*^9, 3.7083620940246973`*^9}, {
   3.7083774971510987`*^9, 3.7083775009764814`*^9}, {3.7083784138960266`*^9, 
   3.708378422344203*^9}, 3.708424805570407*^9, {3.862661687585826*^9, 
   3.862661688646045*^9}, 3.8973961153921123`*^9},
 CellLabel->"In[97]:=",ExpressionUUID->"6f7b3665-1806-46bd-a798-fb39717bb2d9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for x, \[Epsilon]", "Subsection",
 CellChangeTimes->{{3.609854658688661*^9, 3.6098546599207315`*^9}, {
  3.609855870103756*^9, 3.6098558734159455`*^9}, {3.6265437076403923`*^9, 
  3.626543708172394*^9}},ExpressionUUID->"bb141f46-fa25-4017-9882-\
bb68a380e46f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"d2fx\[Epsilon]", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dx\[Epsilon]vars1", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dx\[Epsilon]vars2", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dx\[Epsilon]vars3", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kk", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", "nx"}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jj", "=", 
        RowBox[{"nx", "+", "1"}]}], ",", 
       RowBox[{"jj", "\[LessEqual]", 
        RowBox[{"nx", "+", "ne"}]}], ",", 
       RowBox[{"jj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"kk", "++"}], ";", "\[IndentingNewLine]", 
        RowBox[{"d2fx\[Epsilon]", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"d2fx\[Epsilon]", ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"D", "[", 
                  RowBox[{"F", ",", 
                   RowBox[{"{", 
                    RowBox[{"state", "[", 
                    RowBox[{"[", "ii", "]"}], "]"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"state", "[", 
                    RowBox[{"[", "jj", "]"}], "]"}], "}"}]}], "]"}], "/.", 
                 "derivrule"}], "/.", "ssrule"}], "/.", "ssvalrule"}], "/.", 
              "prule"}], "/.", "epsrule"}]}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"dx\[Epsilon]vars1", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"dx\[Epsilon]vars1", ",", 
            RowBox[{
             RowBox[{"H2", "[", "s", "]"}], "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"1", ";;", "nx"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"ii", "-", "1"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", "jj"}]}],
               "]"}], "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dx\[Epsilon]vars2", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"dx\[Epsilon]vars2", ",", 
            RowBox[{
             RowBox[{"G2", "[", "s", "]"}], "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"1", ";;", "ny"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"ii", "-", "1"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", "jj"}]}],
               "]"}], "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dx\[Epsilon]vars3", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"dx\[Epsilon]vars3", ",", 
            RowBox[{
             RowBox[{"G2", "[", "sp", "]"}], "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"1", ";;", "ny"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"ii", "-", "1"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", "jj"}]}],
               "]"}], "]"}]}], "}"}], "]"}]}], ";"}]}], "\[IndentingNewLine]",
       "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dx\[Epsilon]vars", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"{", 
     RowBox[{
     "dx\[Epsilon]vars1", ",", "dx\[Epsilon]vars2", ",", 
      "dx\[Epsilon]vars3"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Nx\[Epsilon]", ",", "Mx\[Epsilon]"}], "}"}], "=", 
   RowBox[{"CoefficientArrays", "[", 
    RowBox[{"d2fx\[Epsilon]", ",", "dx\[Epsilon]vars"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"Norm", "[", 
      RowBox[{"Simplify", "[", 
       RowBox[{"d2fx\[Epsilon]", "-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Mx\[Epsilon]", ".", "dx\[Epsilon]vars"}], "+", 
          "Nx\[Epsilon]"}], ")"}]}], "]"}], "]"}], "]"}], ";"}], 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.6250636277755356`*^9, 3.6250636468598285`*^9}, {
   3.625063682043436*^9, 3.625063720191961*^9}, {3.6250639698682537`*^9, 
   3.62506398910828*^9}, {3.626528076906588*^9, 3.6265282191159067`*^9}, {
   3.6265282553650074`*^9, 3.626528431554425*^9}, {3.626528467480505*^9, 
   3.6265285052435894`*^9}, {3.626529679843213*^9, 3.626529704813276*^9}, {
   3.6265303526870546`*^9, 3.6265304377781796`*^9}, {3.6265304751822357`*^9, 
   3.626530487874254*^9}, {3.626530528764312*^9, 3.6265306149004335`*^9}, {
   3.6265306601224976`*^9, 3.626530712127571*^9}, {3.626531040444271*^9, 
   3.6265310926003857`*^9}, {3.626531123907476*^9, 3.626531151873535*^9}, {
   3.6265374354340315`*^9, 3.6265374594800806`*^9}, {3.62653749418016*^9, 
   3.6265374960201635`*^9}, {3.626537563566331*^9, 3.6265375800293674`*^9}, {
   3.62653845364045*^9, 3.626538551859681*^9}, {3.6265385960197725`*^9, 
   3.626538608995826*^9}, {3.6265386506559095`*^9, 3.626538653795915*^9}, {
   3.6265403567584476`*^9, 3.626540377901491*^9}, {3.626540424454612*^9, 
   3.6265404750277233`*^9}, {3.626540508107797*^9, 3.6265405986870427`*^9}, {
   3.6265406466631775`*^9, 3.6265406520061884`*^9}, {3.626542247711773*^9, 
   3.626542264413796*^9}, {3.6265429495483136`*^9, 3.626542982155406*^9}, {
   3.6265430266185226`*^9, 3.626543082657637*^9}, {3.626543325219528*^9, 
   3.6265433288295355`*^9}, {3.6265434461388006`*^9, 
   3.6265436387542453`*^9}, {3.6265436992673736`*^9, 
   3.6265437637005367`*^9}, {3.626545668468815*^9, 3.626545676712947*^9}, {
   3.626545789744452*^9, 3.6265457927795086`*^9}, 3.626563243248466*^9, {
   3.6267346166243525`*^9, 3.6267346364628305`*^9}, {3.6267347823725266`*^9, 
   3.6267348245094943`*^9}, 3.650922582805098*^9, 3.6509907034310317`*^9, {
   3.7082787900697627`*^9, 3.708278791619887*^9}, {3.70836207396008*^9, 
   3.7083620923673987`*^9}, 3.8626616980933743`*^9, 3.8973961173164186`*^9},
 CellLabel->
  "In[104]:=",ExpressionUUID->"1b8b7f01-17e9-41ee-bd5a-035203f7e576"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for x, \[Chi]", "Subsection",
 CellChangeTimes->{{3.609854658688661*^9, 3.6098546599207315`*^9}, {
  3.609855870103756*^9, 3.6098558734159455`*^9}, {3.6265437076403923`*^9, 
  3.626543708172394*^9}, {3.6265438623728*^9, 
  3.6265438626028*^9}},ExpressionUUID->"449fd1aa-ccd6-4a43-97d5-fac0e74ffeaa"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"d2fx\[Chi]", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dx\[Chi]vars1", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dx\[Chi]vars2", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dx\[Chi]vars3", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", "nx"}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jj", "=", 
        RowBox[{"nx", "+", "ne", "+", "1"}]}], ",", 
       RowBox[{"jj", "\[LessEqual]", 
        RowBox[{"nx", "+", "ne", "+", "1"}]}], ",", 
       RowBox[{"jj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"d2fx\[Chi]", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"d2fx\[Chi]", ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"D", "[", 
                   RowBox[{"F", ",", 
                    RowBox[{"{", 
                    RowBox[{"state", "[", 
                    RowBox[{"[", "ii", "]"}], "]"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"state", "[", 
                    RowBox[{"[", "jj", "]"}], "]"}], "}"}]}], "]"}], "/.", 
                  "derivrule"}], "/.", "ssrule"}], "/.", "ssvalrule"}], "/.", 
               "prule"}], "/.", "epsrule"}], "/.", "epsprule1"}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dx\[Chi]vars1", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"dx\[Chi]vars1", ",", 
            RowBox[{
             RowBox[{"H2", "[", "s", "]"}], "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"1", ";;", "nx"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"ii", "-", "1"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", "jj"}]}],
               "]"}], "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dx\[Chi]vars2", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"dx\[Chi]vars2", ",", 
            RowBox[{
             RowBox[{"G2", "[", "s", "]"}], "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"1", ";;", "ny"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"ii", "-", "1"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", "jj"}]}],
               "]"}], "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"dx\[Chi]vars3", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"dx\[Chi]vars3", ",", 
            RowBox[{
             RowBox[{"G2", "[", "sp", "]"}], "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"1", ";;", "ny"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"ii", "-", "1"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", "jj"}]}],
               "]"}], "]"}]}], "}"}], "]"}]}], ";"}]}], "\[IndentingNewLine]",
       "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dx\[Chi]vars", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"{", 
     RowBox[{"dx\[Chi]vars1", ",", "dx\[Chi]vars2", ",", "dx\[Chi]vars3"}], 
     "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Nx\[Chi]", ",", "Mx\[Chi]"}], "}"}], "=", 
   RowBox[{"CoefficientArrays", "[", 
    RowBox[{"d2fx\[Chi]", ",", "dx\[Chi]vars"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"Norm", "[", 
      RowBox[{"Simplify", "[", 
       RowBox[{"d2fx\[Chi]", "-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Mx\[Chi]", ".", "dx\[Chi]vars"}], "+", "Nx\[Chi]"}], 
         ")"}]}], "]"}], "]"}], "]"}], ";"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.6250636277755356`*^9, 3.6250636468598285`*^9}, {
   3.625063682043436*^9, 3.625063720191961*^9}, {3.6250639698682537`*^9, 
   3.62506398910828*^9}, {3.626528076906588*^9, 3.6265282191159067`*^9}, {
   3.6265282553650074`*^9, 3.626528431554425*^9}, {3.626528467480505*^9, 
   3.6265285052435894`*^9}, {3.626529679843213*^9, 3.626529704813276*^9}, {
   3.6265303526870546`*^9, 3.6265304377781796`*^9}, {3.6265304751822357`*^9, 
   3.626530487874254*^9}, {3.626530528764312*^9, 3.6265306149004335`*^9}, {
   3.6265306601224976`*^9, 3.626530712127571*^9}, {3.626531040444271*^9, 
   3.6265310926003857`*^9}, {3.626531123907476*^9, 3.626531151873535*^9}, {
   3.6265374354340315`*^9, 3.6265374594800806`*^9}, {3.62653749418016*^9, 
   3.6265374960201635`*^9}, {3.626537563566331*^9, 3.6265375800293674`*^9}, {
   3.62653845364045*^9, 3.626538551859681*^9}, {3.6265385960197725`*^9, 
   3.626538608995826*^9}, {3.6265386506559095`*^9, 3.626538653795915*^9}, {
   3.6265403567584476`*^9, 3.626540377901491*^9}, {3.626540424454612*^9, 
   3.6265404750277233`*^9}, {3.626540508107797*^9, 3.6265405986870427`*^9}, {
   3.6265406466631775`*^9, 3.6265406520061884`*^9}, {3.626542247711773*^9, 
   3.626542264413796*^9}, {3.6265429495483136`*^9, 3.626542982155406*^9}, {
   3.6265430266185226`*^9, 3.626543082657637*^9}, {3.626543325219528*^9, 
   3.6265433288295355`*^9}, {3.6265434461388006`*^9, 
   3.6265436387542453`*^9}, {3.6265436992673736`*^9, 
   3.6265437637005367`*^9}, {3.626543864762804*^9, 3.6265439192689176`*^9}, {
   3.626545680575014*^9, 3.626545689553094*^9}, {3.626545794703517*^9, 
   3.6265457997835884`*^9}, 3.6265632436684666`*^9, {3.626698117843676*^9, 
   3.626698120353681*^9}, {3.626734724078006*^9, 3.6267347378383484`*^9}, {
   3.626734804549036*^9, 3.6267348991092186`*^9}, {3.627153984876656*^9, 
   3.627153986216658*^9}, 3.650922585715102*^9, 3.6509907088580494`*^9, {
   3.7082787928419847`*^9, 3.7082787948381443`*^9}, {3.7083620757324*^9, 
   3.7083620905670743`*^9}, 3.862661699942479*^9, {3.8973961195370197`*^9, 
   3.8973961225277433`*^9}},
 CellLabel->
  "In[112]:=",ExpressionUUID->"a5d47e29-8574-485a-af53-e312051af503"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for \[Epsilon], \[Epsilon]", "Subsection",
 CellChangeTimes->{{3.609854658688661*^9, 3.6098546599207315`*^9}, {
  3.609855870103756*^9, 3.6098558734159455`*^9}, {3.6265437076403923`*^9, 
  3.626543708172394*^9}, {3.6265438623728*^9, 3.6265438626028*^9}, {
  3.6265439810720696`*^9, 
  3.626543982352072*^9}},ExpressionUUID->"032812ad-843e-4146-bf92-\
441052429500"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"d2f\[Epsilon]\[Epsilon]", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d\[Epsilon]\[Epsilon]vars1", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d\[Epsilon]\[Epsilon]vars2", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d\[Epsilon]\[Epsilon]vars3", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", 
     RowBox[{"nx", "+", "1"}]}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{"nx", "+", "ne"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jj", "=", 
        RowBox[{"nx", "+", "1"}]}], ",", 
       RowBox[{"jj", "\[LessEqual]", 
        RowBox[{"nx", "+", "ne"}]}], ",", 
       RowBox[{"jj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"jj", "\[GreaterEqual]", "ii"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"d2f\[Epsilon]\[Epsilon]", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{"d2f\[Epsilon]\[Epsilon]", ",", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"D", "[", 
                    RowBox[{"F", ",", 
                    RowBox[{"{", 
                    RowBox[{"state", "[", 
                    RowBox[{"[", "ii", "]"}], "]"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"state", "[", 
                    RowBox[{"[", "jj", "]"}], "]"}], "}"}]}], "]"}], "/.", 
                    "derivrule"}], "/.", "ssrule"}], "/.", "ssvalrule"}], "/.",
                  "prule"}], "/.", "epsrule"}]}], "}"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"d\[Epsilon]\[Epsilon]vars1", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{"d\[Epsilon]\[Epsilon]vars1", ",", 
               RowBox[{
                RowBox[{"H2", "[", "s", "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"1", ";;", "nx"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                   "jj"}]}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"d\[Epsilon]\[Epsilon]vars2", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{"d\[Epsilon]\[Epsilon]vars2", ",", 
               RowBox[{
                RowBox[{"G2", "[", "s", "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"1", ";;", "ny"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                   "jj"}]}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"d\[Epsilon]\[Epsilon]vars3", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{"d\[Epsilon]\[Epsilon]vars3", ",", 
               RowBox[{
                RowBox[{"G2", "[", "sp", "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"1", ";;", "ny"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                   "jj"}]}], "]"}], "]"}]}], "}"}], "]"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"jj", "<", "ii"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"d2f\[Epsilon]\[Epsilon]", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{"d2f\[Epsilon]\[Epsilon]", ",", "\[IndentingNewLine]", 
               RowBox[{"Flatten", "[", 
                RowBox[{"Thread", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"H2", "[", "s", "]"}], "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"1", ";;", "nx"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                    "jj"}]}], "]"}], "]"}], "-", 
                  RowBox[{
                   RowBox[{"h2", "[", "s", "]"}], "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"1", ";;", "nx"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                    "jj"}]}], "]"}], "]"}]}], "]"}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Flatten", "[", 
                RowBox[{"Thread", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"G2", "[", "s", "]"}], "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"1", ";;", "ny"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                    "jj"}]}], "]"}], "]"}], "-", 
                  RowBox[{
                   RowBox[{"g2", "[", "s", "]"}], "[", 
                   RowBox[{"[", 
                    RowBox[{
                    RowBox[{"1", ";;", "ny"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                    "jj"}]}], "]"}], "]"}]}], "]"}], "]"}]}], 
              "\[IndentingNewLine]", "}"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"d\[Epsilon]\[Epsilon]vars1", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{"d\[Epsilon]\[Epsilon]vars1", ",", 
               RowBox[{
                RowBox[{"h2", "[", "s", "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"1", ";;", "nx"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                   "jj"}]}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"d\[Epsilon]\[Epsilon]vars2", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{"d\[Epsilon]\[Epsilon]vars2", ",", 
               RowBox[{
                RowBox[{"g2", "[", "s", "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"1", ";;", "ny"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                   "jj"}]}], "]"}], "]"}]}], "}"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"d\[Epsilon]\[Epsilon]vars3", "=", 
            RowBox[{"Flatten", "[", 
             RowBox[{"{", 
              RowBox[{"d\[Epsilon]\[Epsilon]vars3", ",", 
               RowBox[{
                RowBox[{"g2", "[", "sp", "]"}], "[", 
                RowBox[{"[", 
                 RowBox[{
                  RowBox[{"1", ";;", "ny"}], ",", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ii", "-", "1"}], ")"}], "*", 
                    RowBox[{"(", 
                    RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", 
                   "jj"}]}], "]"}], "]"}]}], "}"}], "]"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
     ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d\[Epsilon]\[Epsilon]vars", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"{", 
     RowBox[{
     "d\[Epsilon]\[Epsilon]vars1", ",", "d\[Epsilon]\[Epsilon]vars2", ",", 
      "d\[Epsilon]\[Epsilon]vars3"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"N\[Epsilon]\[Epsilon]", ",", "M\[Epsilon]\[Epsilon]"}], "}"}], 
   "=", 
   RowBox[{"CoefficientArrays", "[", 
    RowBox[{"d2f\[Epsilon]\[Epsilon]", ",", "d\[Epsilon]\[Epsilon]vars"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"Norm", "[", 
      RowBox[{"Simplify", "[", 
       RowBox[{"d2f\[Epsilon]\[Epsilon]", "-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"M\[Epsilon]\[Epsilon]", ".", "d\[Epsilon]\[Epsilon]vars"}],
           "+", "N\[Epsilon]\[Epsilon]"}], ")"}]}], "]"}], "]"}], "]"}], 
    ";"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.6250636277755356`*^9, 3.6250636468598285`*^9}, {
   3.625063682043436*^9, 3.625063720191961*^9}, {3.6250639698682537`*^9, 
   3.62506398910828*^9}, {3.626528076906588*^9, 3.6265282191159067`*^9}, {
   3.6265282553650074`*^9, 3.626528431554425*^9}, {3.626528467480505*^9, 
   3.6265285052435894`*^9}, {3.626529679843213*^9, 3.626529704813276*^9}, {
   3.6265303526870546`*^9, 3.6265304377781796`*^9}, {3.6265304751822357`*^9, 
   3.626530487874254*^9}, {3.626530528764312*^9, 3.6265306149004335`*^9}, {
   3.6265306601224976`*^9, 3.626530712127571*^9}, {3.626531040444271*^9, 
   3.6265310926003857`*^9}, {3.626531123907476*^9, 3.626531151873535*^9}, {
   3.6265374354340315`*^9, 3.6265374594800806`*^9}, {3.62653749418016*^9, 
   3.6265374960201635`*^9}, {3.626537563566331*^9, 3.6265375800293674`*^9}, {
   3.62653845364045*^9, 3.626538551859681*^9}, {3.6265385960197725`*^9, 
   3.626538608995826*^9}, {3.6265386506559095`*^9, 3.626538653795915*^9}, {
   3.6265403567584476`*^9, 3.626540377901491*^9}, {3.626540424454612*^9, 
   3.6265404750277233`*^9}, {3.626540508107797*^9, 3.6265405986870427`*^9}, {
   3.6265406466631775`*^9, 3.6265406520061884`*^9}, {3.626542247711773*^9, 
   3.626542264413796*^9}, {3.6265429495483136`*^9, 3.626542982155406*^9}, {
   3.6265430266185226`*^9, 3.626543082657637*^9}, {3.626543325219528*^9, 
   3.6265433288295355`*^9}, {3.6265434461388006`*^9, 
   3.6265436387542453`*^9}, {3.6265436992673736`*^9, 
   3.6265437637005367`*^9}, {3.626543864762804*^9, 3.6265439192689176`*^9}, {
   3.6265439968291006`*^9, 3.626544056951226*^9}, {3.6265443632659655`*^9, 
   3.626544363395966*^9}, {3.626545692149153*^9, 3.6265457035842953`*^9}, {
   3.626545803770645*^9, 3.6265458057507057`*^9}, 3.626563244128467*^9, {
   3.626734990409155*^9, 3.626735068989276*^9}, {3.627153991866666*^9, 
   3.627154045988742*^9}, {3.6271541181308427`*^9, 3.6271541674929123`*^9}, {
   3.627154295092094*^9, 3.627154295652095*^9}, 3.6509225882851057`*^9, 
   3.650990715921074*^9, {3.708278797117327*^9, 3.7082787984334326`*^9}, {
   3.7083620786339226`*^9, 3.7083620882546577`*^9}, 3.862661702295752*^9, 
   3.8973961253503437`*^9},
 CellLabel->
  "In[119]:=",ExpressionUUID->"0b53d42c-d8e8-4a22-a46d-6a956ecae149"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for \[Epsilon], \[Chi]", "Subsection",
 CellChangeTimes->{{3.609854658688661*^9, 3.6098546599207315`*^9}, {
  3.609855870103756*^9, 3.6098558734159455`*^9}, {3.6265437076403923`*^9, 
  3.626543708172394*^9}, {3.6265438623728*^9, 3.6265438626028*^9}, {
  3.6265439810720696`*^9, 3.626543982352072*^9}, {3.6265440466752043`*^9, 
  3.626544047035205*^9}},ExpressionUUID->"061f3404-cfa4-41a8-aa9f-\
c4d4d0863ef3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"d2f\[Epsilon]\[Chi]", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d\[Epsilon]\[Chi]vars1", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d\[Epsilon]\[Chi]vars2", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d\[Epsilon]\[Chi]vars3", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"kk", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", 
     RowBox[{"nx", "+", "1"}]}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{"nx", "+", "ne"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jj", "=", 
        RowBox[{"nx", "+", "ne", "+", "1"}]}], ",", 
       RowBox[{"jj", "\[LessEqual]", 
        RowBox[{"nx", "+", "ne", "+", "1"}]}], ",", 
       RowBox[{"jj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"kk", "++"}], ";", "\[IndentingNewLine]", 
        RowBox[{"d2f\[Epsilon]\[Chi]", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"d2f\[Epsilon]\[Chi]", ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"D", "[", 
                   RowBox[{"F", ",", 
                    RowBox[{"{", 
                    RowBox[{"state", "[", 
                    RowBox[{"[", "ii", "]"}], "]"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"state", "[", 
                    RowBox[{"[", "jj", "]"}], "]"}], "}"}]}], "]"}], "/.", 
                  "derivrule"}], "/.", "ssrule"}], "/.", "ssvalrule"}], "/.", 
               "epsrule"}], "/.", "prule"}], "/.", "epsprule1"}]}], "}"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"d\[Epsilon]\[Chi]vars1", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"d\[Epsilon]\[Chi]vars1", ",", 
            RowBox[{
             RowBox[{"H2", "[", "s", "]"}], "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"1", ";;", "nx"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"ii", "-", "1"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", "jj"}]}],
               "]"}], "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"d\[Epsilon]\[Chi]vars2", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"d\[Epsilon]\[Chi]vars2", ",", 
            RowBox[{
             RowBox[{"G2", "[", "s", "]"}], "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"1", ";;", "ny"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"ii", "-", "1"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", "jj"}]}],
               "]"}], "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"d\[Epsilon]\[Chi]vars3", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"d\[Epsilon]\[Chi]vars3", ",", 
            RowBox[{
             RowBox[{"G2", "[", "sp", "]"}], "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"1", ";;", "ny"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"ii", "-", "1"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", "jj"}]}],
               "]"}], "]"}]}], "}"}], "]"}]}], ";"}]}], "\[IndentingNewLine]",
       "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d\[Epsilon]\[Chi]vars", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"{", 
     RowBox[{
     "d\[Epsilon]\[Chi]vars1", ",", "d\[Epsilon]\[Chi]vars2", ",", 
      "d\[Epsilon]\[Chi]vars3"}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"N\[Epsilon]\[Chi]", ",", "M\[Epsilon]\[Chi]"}], "}"}], "=", 
   RowBox[{"CoefficientArrays", "[", 
    RowBox[{"d2f\[Epsilon]\[Chi]", ",", "d\[Epsilon]\[Chi]vars"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"Norm", "[", 
      RowBox[{"Simplify", "[", 
       RowBox[{"d2f\[Epsilon]\[Chi]", "-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"M\[Epsilon]\[Chi]", ".", "d\[Epsilon]\[Chi]vars"}], "+", 
          "N\[Epsilon]\[Chi]"}], ")"}]}], "]"}], "]"}], "]"}], ";"}], 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.6250636277755356`*^9, 3.6250636468598285`*^9}, {
   3.625063682043436*^9, 3.625063720191961*^9}, {3.6250639698682537`*^9, 
   3.62506398910828*^9}, {3.626528076906588*^9, 3.6265282191159067`*^9}, {
   3.6265282553650074`*^9, 3.626528431554425*^9}, {3.626528467480505*^9, 
   3.6265285052435894`*^9}, {3.626529679843213*^9, 3.626529704813276*^9}, {
   3.6265303526870546`*^9, 3.6265304377781796`*^9}, {3.6265304751822357`*^9, 
   3.626530487874254*^9}, {3.626530528764312*^9, 3.6265306149004335`*^9}, {
   3.6265306601224976`*^9, 3.626530712127571*^9}, {3.626531040444271*^9, 
   3.6265310926003857`*^9}, {3.626531123907476*^9, 3.626531151873535*^9}, {
   3.6265374354340315`*^9, 3.6265374594800806`*^9}, {3.62653749418016*^9, 
   3.6265374960201635`*^9}, {3.626537563566331*^9, 3.6265375800293674`*^9}, {
   3.62653845364045*^9, 3.626538551859681*^9}, {3.6265385960197725`*^9, 
   3.626538608995826*^9}, {3.6265386506559095`*^9, 3.626538653795915*^9}, {
   3.6265403567584476`*^9, 3.626540377901491*^9}, {3.626540424454612*^9, 
   3.6265404750277233`*^9}, {3.626540508107797*^9, 3.6265405986870427`*^9}, {
   3.6265406466631775`*^9, 3.6265406520061884`*^9}, {3.626542247711773*^9, 
   3.626542264413796*^9}, {3.6265429495483136`*^9, 3.626542982155406*^9}, {
   3.6265430266185226`*^9, 3.626543082657637*^9}, {3.626543325219528*^9, 
   3.6265433288295355`*^9}, {3.6265434461388006`*^9, 
   3.6265436387542453`*^9}, {3.6265436992673736`*^9, 
   3.6265437637005367`*^9}, {3.626543864762804*^9, 3.6265439192689176`*^9}, {
   3.6265439968291006`*^9, 3.6265440748452616`*^9}, {3.6265457114284267`*^9, 
   3.6265457277216296`*^9}, {3.6265458089347134`*^9, 3.6265458106717725`*^9}, 
   3.626563244568468*^9, {3.6266981083876314`*^9, 3.626698110613637*^9}, {
   3.62673507910929*^9, 3.626735154466403*^9}, 3.6509225909351096`*^9, 
   3.6509907143540673`*^9, {3.7082788003135834`*^9, 3.7082788015226803`*^9}, {
   3.7083620805872746`*^9, 3.708362084919055*^9}, 3.862661705303438*^9, 
   3.897396128083872*^9},
 CellLabel->
  "In[126]:=",ExpressionUUID->"c997c8c4-c3a2-48e8-a7c6-f15923db04a5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for \[Chi], \[Chi]", "Subsection",
 CellChangeTimes->{{3.609854658688661*^9, 3.6098546599207315`*^9}, {
  3.609855870103756*^9, 3.6098558734159455`*^9}, {3.6265437076403923`*^9, 
  3.626543708172394*^9}, {3.6265438623728*^9, 3.6265438626028*^9}, {
  3.6265439810720696`*^9, 3.626543982352072*^9}, {3.6265440466752043`*^9, 
  3.626544047035205*^9}, {3.626544091098345*^9, 
  3.626544091408346*^9}},ExpressionUUID->"05a76877-f922-4fda-8f03-\
33936442b3d2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"d2f\[Chi]\[Chi]", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d\[Chi]\[Chi]vars1", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d\[Chi]\[Chi]vars2", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d\[Chi]\[Chi]vars3", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", 
     RowBox[{"nx", "+", "ne", "+", "1"}]}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{"nx", "+", "ne", "+", "1"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jj", "=", 
        RowBox[{"nx", "+", "ne", "+", "1"}]}], ",", 
       RowBox[{"jj", "\[LessEqual]", 
        RowBox[{"nx", "+", "ne", "+", "1"}]}], ",", 
       RowBox[{"jj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"d2f\[Chi]\[Chi]", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"d2f\[Chi]\[Chi]", ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"D", "[", 
                  RowBox[{"F", ",", 
                   RowBox[{"{", 
                    RowBox[{"state", "[", 
                    RowBox[{"[", "ii", "]"}], "]"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"state", "[", 
                    RowBox[{"[", "jj", "]"}], "]"}], "}"}]}], "]"}], "/.", 
                 "derivrule"}], "/.", "ssrule"}], "/.", "ssvalrule"}], "/.", 
              "prule"}], "/.", "epsrule"}]}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"d\[Chi]\[Chi]vars1", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"d\[Chi]\[Chi]vars1", ",", 
            RowBox[{
             RowBox[{"H2", "[", "s", "]"}], "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"1", ";;", "nx"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"ii", "-", "1"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", "jj"}]}],
               "]"}], "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"d\[Chi]\[Chi]vars2", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"d\[Chi]\[Chi]vars2", ",", 
            RowBox[{
             RowBox[{"G2", "[", "s", "]"}], "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"1", ";;", "ny"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"ii", "-", "1"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", "jj"}]}],
               "]"}], "]"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"d\[Chi]\[Chi]vars3", "=", 
         RowBox[{"Flatten", "[", 
          RowBox[{"{", 
           RowBox[{"d\[Chi]\[Chi]vars3", ",", 
            RowBox[{
             RowBox[{"G2", "[", "sp", "]"}], "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"1", ";;", "ny"}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"ii", "-", "1"}], ")"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"nx", "+", "ne", "+", "1"}], ")"}]}], "+", "jj"}]}],
               "]"}], "]"}]}], "}"}], "]"}]}], ";"}]}], "\[IndentingNewLine]",
       "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d\[Chi]\[Chi]vars", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"{", 
     RowBox[{
     "d\[Chi]\[Chi]vars1", ",", "d\[Chi]\[Chi]vars2", ",", 
      "d\[Chi]\[Chi]vars3"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"E0", ",", "E1", ",", "E2"}], "}"}], "=", 
   RowBox[{"CoefficientArrays", "[", 
    RowBox[{"d2f\[Chi]\[Chi]", ",", "epsp"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d2f\[Chi]\[Chi]1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"E0", "+", 
      RowBox[{"Expand", "[", 
       RowBox[{"E2", ".", "epsp", ".", "epsp"}], "]"}]}], "/.", "epsprule2"}],
     "/.", "epsprule1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"N\[Chi]\[Chi]", ",", "M\[Chi]\[Chi]"}], "}"}], "=", 
   RowBox[{"CoefficientArrays", "[", 
    RowBox[{"d2f\[Chi]\[Chi]1", ",", "d\[Chi]\[Chi]vars"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{"d2f\[Chi]\[Chi]", "-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"M\[Chi]\[Chi]", ".", "d\[Chi]\[Chi]vars"}], "+", 
           "N\[Chi]\[Chi]"}], ")"}]}], "]"}], "/.", "epsprule1"}], "]"}], 
     "]"}], ";"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.6250636277755356`*^9, 3.6250636468598285`*^9}, {
   3.625063682043436*^9, 3.625063720191961*^9}, {3.6250639698682537`*^9, 
   3.62506398910828*^9}, {3.626528076906588*^9, 3.6265282191159067`*^9}, {
   3.6265282553650074`*^9, 3.626528431554425*^9}, {3.626528467480505*^9, 
   3.6265285052435894`*^9}, {3.626529679843213*^9, 3.626529704813276*^9}, {
   3.6265303526870546`*^9, 3.6265304377781796`*^9}, {3.6265304751822357`*^9, 
   3.626530487874254*^9}, {3.626530528764312*^9, 3.6265306149004335`*^9}, {
   3.6265306601224976`*^9, 3.626530712127571*^9}, {3.626531040444271*^9, 
   3.6265310926003857`*^9}, {3.626531123907476*^9, 3.626531151873535*^9}, {
   3.6265374354340315`*^9, 3.6265374594800806`*^9}, {3.62653749418016*^9, 
   3.6265374960201635`*^9}, {3.626537563566331*^9, 3.6265375800293674`*^9}, {
   3.62653845364045*^9, 3.626538551859681*^9}, {3.6265385960197725`*^9, 
   3.626538608995826*^9}, {3.6265386506559095`*^9, 3.626538653795915*^9}, {
   3.6265403567584476`*^9, 3.626540377901491*^9}, {3.626540424454612*^9, 
   3.6265404750277233`*^9}, {3.626540508107797*^9, 3.6265405986870427`*^9}, {
   3.6265406466631775`*^9, 3.6265406520061884`*^9}, {3.626542247711773*^9, 
   3.626542264413796*^9}, {3.6265429495483136`*^9, 3.626542982155406*^9}, {
   3.6265430266185226`*^9, 3.626543082657637*^9}, {3.626543325219528*^9, 
   3.6265433288295355`*^9}, {3.6265434461388006`*^9, 
   3.6265436387542453`*^9}, {3.6265436992673736`*^9, 
   3.6265437637005367`*^9}, {3.626543864762804*^9, 3.6265439192689176`*^9}, {
   3.6265439968291006`*^9, 3.6265441447074537`*^9}, {3.62654573524074*^9, 
   3.626545752420967*^9}, {3.6265458132277794`*^9, 3.626545814959799*^9}, 
   3.6265632449984684`*^9, 3.626637106768056*^9, {3.626637175969202*^9, 
   3.6266371967652674`*^9}, {3.626711084490223*^9, 3.62671108991724*^9}, {
   3.6267351577764072`*^9, 3.6267352087767353`*^9}, {3.6276696565325565`*^9, 
   3.6276696583525605`*^9}, {3.627685988208785*^9, 3.6276859888047876`*^9}, {
   3.6276860996791043`*^9, 3.627686102989111*^9}, {3.627686332528778*^9, 
   3.627686337484788*^9}, 3.6276871241523027`*^9, {3.6276874215172977`*^9, 
   3.6276874267425375`*^9}, 3.6509225934651127`*^9, 3.650990718542082*^9, 
   3.6510009667140045`*^9, {3.6510554160156283`*^9, 3.6510554187706356`*^9}, 
   3.6510558209235983`*^9, {3.651057767666791*^9, 3.6510577729467983`*^9}, 
   3.6510593630377245`*^9, {3.708354049249303*^9, 3.7083540891273026`*^9}, {
   3.7083582318252544`*^9, 3.708358234792551*^9}, 3.862661707810356*^9, 
   3.897396130843965*^9},
 CellLabel->
  "In[134]:=",ExpressionUUID->"4490009d-397e-4587-9412-3358248c900e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exporting", "Section",
 CellChangeTimes->{{3.626547826105698*^9, 
  3.626547829345702*^9}},ExpressionUUID->"42e53149-82d1-4ce3-a6db-\
74501597abf1"],

Cell[CellGroupData[{

Cell["Output Rules", "Subsection",
 CellChangeTimes->{{3.6266131729907217`*^9, 
  3.626613174520724*^9}},ExpressionUUID->"a758b6f9-2285-453a-a0be-\
8784b6f8f895"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"outputrule", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Thread", "[", 
       RowBox[{"xvarss", "\[Rule]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"xss", "[", 
           RowBox[{"[", 
            RowBox[{"i", "-", "1", "+", "zero"}], "]"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "nx"}], "}"}]}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Thread", "[", 
       RowBox[{"yvarss", "\[Rule]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"yss", "[", 
           RowBox[{"[", 
            RowBox[{"i", "-", "1", "+", "zero"}], "]"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "ny"}], "}"}]}], "]"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Thread", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Flatten", "[", 
          RowBox[{"G", "[", "sp", "]"}], "]"}], ")"}], "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Gsp", "[", 
             RowBox[{"[", 
              RowBox[{"i", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"j", "-", "1"}], ")"}], "*", "ny"}], "-", "1", "+", 
               "zero"}], "]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", "ny"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", "1", ",", 
              RowBox[{"nx", "+", "ne", "+", "1"}]}], "}"}]}], "]"}], "]"}], 
         ")"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Thread", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Flatten", "[", 
          RowBox[{"G", "[", "s", "]"}], "]"}], ")"}], "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Gs", "[", 
             RowBox[{"[", 
              RowBox[{"i", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"j", "-", "1"}], ")"}], "*", "ny"}], "-", "1", "+", 
               "zero"}], "]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", "ny"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", "1", ",", 
              RowBox[{"nx", "+", "ne", "+", "1"}]}], "}"}]}], "]"}], "]"}], 
         ")"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Thread", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Flatten", "[", 
          RowBox[{"H", "[", "s", "]"}], "]"}], ")"}], "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Hs", "[", 
             RowBox[{"[", 
              RowBox[{"i", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"j", "-", "1"}], ")"}], "*", "nx"}], "-", "1", "+", 
               "zero"}], "]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", "nx"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", "1", ",", 
              RowBox[{"nx", "+", "ne", "+", "1"}]}], "}"}]}], "]"}], "]"}], 
         ")"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Thread", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Flatten", "[", 
          RowBox[{"G2", "[", "sp", "]"}], "]"}], ")"}], "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"Flatten", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"G2sp", "[", 
             RowBox[{"[", 
              RowBox[{"i", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"j", "-", "1"}], ")"}], "*", "ny"}], "-", "1", "+", 
               "zero"}], "]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "1", ",", "ny"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"j", ",", "1", ",", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"nx", "+", "ne", "+", "1"}], ")"}], "2"]}], "}"}]}], 
           "]"}], "]"}], ")"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Thread", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Pfun", "[", 
              RowBox[{"s", ",", "sp"}], "]"}], "[", 
             RowBox[{"bstar", ",", "llambda"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"bstar", ",", "llambda"}], "}"}], "}"}]}], "]"}], "/.", 
          "derivrule"}], ")"}], "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"dP1ssp", ",", "dP2ssp"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Pss", "[", 
        RowBox[{"s", ",", "sp"}], "]"}], "\[Rule]", "Pssp"}], ",", 
      RowBox[{
       RowBox[{"nnu", "[", "s", "]"}], "\[Rule]", "nnus"}], ",", 
      RowBox[{
       RowBox[{"varphi", "[", "s", "]"}], "\[Rule]", "varphis"}]}], 
     "\[IndentingNewLine]", "}"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6265512877328506`*^9, 3.6265514799483604`*^9}, {
   3.626551637100733*^9, 3.6265516417067423`*^9}, {3.6265604522451887`*^9, 
   3.6265604647324486`*^9}, {3.6265606993240414`*^9, 3.626560712347509*^9}, {
   3.626560837156871*^9, 3.6265608654903255`*^9}, {3.6265610083404846`*^9, 
   3.6265610503155437`*^9}, {3.626561301852016*^9, 3.626561310462028*^9}, {
   3.626562504547737*^9, 3.626562610168888*^9}, 3.626562825946206*^9, {
   3.6265652188442516`*^9, 3.626565226674266*^9}, {3.6265653218234577`*^9, 
   3.6265653535365133`*^9}, {3.6266131761087265`*^9, 
   3.6266131932387505`*^9}, {3.626613231456805*^9, 3.62661324240882*^9}, {
   3.6266132751908674`*^9, 3.62661329036489*^9}, {3.6266248241256313`*^9, 
   3.626624828465637*^9}, {3.626630813946266*^9, 3.6266308527873573`*^9}, {
   3.6266359794885807`*^9, 3.626635986648595*^9}, {3.6266362076771812`*^9, 
   3.62663622988326*^9}, {3.6266369385144634`*^9, 3.626636977187518*^9}, {
   3.6266372149493046`*^9, 3.6266372159093065`*^9}, {3.6266377452130423`*^9, 
   3.626637752270446*^9}, {3.6266379223336697`*^9, 3.626637930068681*^9}, {
   3.6266382275508456`*^9, 3.626638270465907*^9}, {3.6266384270694056`*^9, 
   3.6266384790695105`*^9}, {3.631049769657566*^9, 3.631049772905593*^9}, {
   3.6509741521438055`*^9, 3.6509741533338566`*^9}, {3.6509919457132864`*^9, 
   3.650991946103287*^9}, {3.650992288618541*^9, 3.6509922924675465`*^9}, {
   3.6509923866817493`*^9, 3.6509923876217504`*^9}, {3.6509960936973314`*^9, 
   3.650996150618414*^9}, {3.650996606491847*^9, 3.650996618816552*^9}, {
   3.6509967712561607`*^9, 3.6509967753023205`*^9}, {3.708378475532385*^9, 
   3.7083784785694466`*^9}, {3.7083832108890405`*^9, 
   3.7083832169316444`*^9}, {3.7373274613750086`*^9, 3.737327471891744*^9}, {
   3.86267859733784*^9, 3.8626785987064714`*^9}, {3.8635350071777225`*^9, 
   3.8635350072492137`*^9}, {3.863535322425104*^9, 3.863535352411892*^9}, {
   3.863537781035551*^9, 3.8635378939973774`*^9}, {3.883757551454631*^9, 
   3.8837575722698393`*^9}, {3.896802975932643*^9, 3.8968029776730857`*^9}, {
   3.8968065531698804`*^9, 3.8968065680729713`*^9}, {3.897581008837347*^9, 
   3.897581013167096*^9}, {3.901191994652194*^9, 3.9011919955709867`*^9}},
 CellLabel->
  "In[162]:=",ExpressionUUID->"e8bc5a8c-d086-4caf-aff5-5ff67bd2b631"],

Cell[BoxData[
 TemplateBox[{
  "Part", "pkspec1", 
   "\"The expression \\!\\(\\*RowBox[{\\\"zero\\\"}]\\) cannot be used as a \
part specification.\"", 2, 162, 10, 25513626908261174456, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.8635355475680456`*^9, 3.8635378202439876`*^9, {3.863537865879323*^9, 
   3.8635378951340866`*^9}, {3.863542454443578*^9, 3.8635424767679033`*^9}, 
   3.8726322529554434`*^9, 3.883756711509104*^9, 3.883759223108239*^9, 
   3.883869873741826*^9, 3.8838700520014496`*^9, 3.8839550996009245`*^9, 
   3.88395650017424*^9, 3.884271334184664*^9, 3.884898936405877*^9, 
   3.8849624753246655`*^9, 3.884964938303738*^9, 3.884965446500622*^9, 
   3.8849862456663914`*^9, 3.885644021088002*^9, 3.8856463078978863`*^9, 
   3.8856470827028275`*^9, 3.896546259697694*^9, 3.8965503070285234`*^9, 
   3.8965661580837393`*^9, 3.896566996928815*^9, 3.8965673267374263`*^9, 
   3.896567410695057*^9, 3.896800839377919*^9, 3.8968021301489162`*^9, 
   3.8968029822629166`*^9, 3.896807932514515*^9, 3.8968216741632376`*^9, 
   3.8968218760340176`*^9, 3.8968239500650587`*^9, 3.8968242370296483`*^9, 
   3.896913150004572*^9, 3.896914434255205*^9, 3.8969812743363624`*^9, 
   3.8969816687530165`*^9, 3.8972381626498013`*^9, 3.8972389130930004`*^9, 
   3.897397255394503*^9, 3.897426513697817*^9, 3.897518980730382*^9, 
   3.8975810608318033`*^9, 3.897581112450904*^9, 3.8977724894509788`*^9, {
   3.9011919795376415`*^9, 3.901192008776721*^9}},
 CellLabel->
  "During evaluation of \
In[162]:=",ExpressionUUID->"5e8ec2cb-f047-44d6-bf71-d873eab74ccd"],

Cell[BoxData[
 TemplateBox[{
  "Part", "pkspec1", 
   "\"The expression \\!\\(\\*RowBox[{\\\"1\\\", \\\"+\\\", \\\"zero\\\"}]\\) \
cannot be used as a part specification.\"", 2, 162, 11, 25513626908261174456, 
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.8635355475680456`*^9, 3.8635378202439876`*^9, {3.863537865879323*^9, 
   3.8635378951340866`*^9}, {3.863542454443578*^9, 3.8635424767679033`*^9}, 
   3.8726322529554434`*^9, 3.883756711509104*^9, 3.883759223108239*^9, 
   3.883869873741826*^9, 3.8838700520014496`*^9, 3.8839550996009245`*^9, 
   3.88395650017424*^9, 3.884271334184664*^9, 3.884898936405877*^9, 
   3.8849624753246655`*^9, 3.884964938303738*^9, 3.884965446500622*^9, 
   3.8849862456663914`*^9, 3.885644021088002*^9, 3.8856463078978863`*^9, 
   3.8856470827028275`*^9, 3.896546259697694*^9, 3.8965503070285234`*^9, 
   3.8965661580837393`*^9, 3.896566996928815*^9, 3.8965673267374263`*^9, 
   3.896567410695057*^9, 3.896800839377919*^9, 3.8968021301489162`*^9, 
   3.8968029822629166`*^9, 3.896807932514515*^9, 3.8968216741632376`*^9, 
   3.8968218760340176`*^9, 3.8968239500650587`*^9, 3.8968242370296483`*^9, 
   3.896913150004572*^9, 3.896914434255205*^9, 3.8969812743363624`*^9, 
   3.8969816687530165`*^9, 3.8972381626498013`*^9, 3.8972389130930004`*^9, 
   3.897397255394503*^9, 3.897426513697817*^9, 3.897518980730382*^9, 
   3.8975810608318033`*^9, 3.897581112450904*^9, 3.8977724894509788`*^9, {
   3.9011919795376415`*^9, 3.9011920087847233`*^9}},
 CellLabel->
  "During evaluation of \
In[162]:=",ExpressionUUID->"23b5f3a9-605b-4bff-950d-f0dd4e843e40"],

Cell[BoxData[
 TemplateBox[{
  "Part", "pkspec1", 
   "\"The expression \\!\\(\\*RowBox[{\\\"2\\\", \\\"+\\\", \\\"zero\\\"}]\\) \
cannot be used as a part specification.\"", 2, 162, 12, 25513626908261174456, 
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.8635355475680456`*^9, 3.8635378202439876`*^9, {3.863537865879323*^9, 
   3.8635378951340866`*^9}, {3.863542454443578*^9, 3.8635424767679033`*^9}, 
   3.8726322529554434`*^9, 3.883756711509104*^9, 3.883759223108239*^9, 
   3.883869873741826*^9, 3.8838700520014496`*^9, 3.8839550996009245`*^9, 
   3.88395650017424*^9, 3.884271334184664*^9, 3.884898936405877*^9, 
   3.8849624753246655`*^9, 3.884964938303738*^9, 3.884965446500622*^9, 
   3.8849862456663914`*^9, 3.885644021088002*^9, 3.8856463078978863`*^9, 
   3.8856470827028275`*^9, 3.896546259697694*^9, 3.8965503070285234`*^9, 
   3.8965661580837393`*^9, 3.896566996928815*^9, 3.8965673267374263`*^9, 
   3.896567410695057*^9, 3.896800839377919*^9, 3.8968021301489162`*^9, 
   3.8968029822629166`*^9, 3.896807932514515*^9, 3.8968216741632376`*^9, 
   3.8968218760340176`*^9, 3.8968239500650587`*^9, 3.8968242370296483`*^9, 
   3.896913150004572*^9, 3.896914434255205*^9, 3.8969812743363624`*^9, 
   3.8969816687530165`*^9, 3.8972381626498013`*^9, 3.8972389130930004`*^9, 
   3.897397255394503*^9, 3.897426513697817*^9, 3.897518980730382*^9, 
   3.8975810608318033`*^9, 3.897581112450904*^9, 3.8977724894509788`*^9, {
   3.9011919795376415`*^9, 3.9011920087921734`*^9}},
 CellLabel->
  "During evaluation of \
In[162]:=",ExpressionUUID->"745730e4-aae8-43a0-acdc-7ce269ece8f5"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"Part\\\", \\\"::\\\", \
\\\"pkspec1\\\"}], \\\"MessageName\\\"]\\) will be suppressed during this \
calculation.\"", 2, 162, 13, 25513626908261174456, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.8635355475680456`*^9, 3.8635378202439876`*^9, {3.863537865879323*^9, 
   3.8635378951340866`*^9}, {3.863542454443578*^9, 3.8635424767679033`*^9}, 
   3.8726322529554434`*^9, 3.883756711509104*^9, 3.883759223108239*^9, 
   3.883869873741826*^9, 3.8838700520014496`*^9, 3.8839550996009245`*^9, 
   3.88395650017424*^9, 3.884271334184664*^9, 3.884898936405877*^9, 
   3.8849624753246655`*^9, 3.884964938303738*^9, 3.884965446500622*^9, 
   3.8849862456663914`*^9, 3.885644021088002*^9, 3.8856463078978863`*^9, 
   3.8856470827028275`*^9, 3.896546259697694*^9, 3.8965503070285234`*^9, 
   3.8965661580837393`*^9, 3.896566996928815*^9, 3.8965673267374263`*^9, 
   3.896567410695057*^9, 3.896800839377919*^9, 3.8968021301489162`*^9, 
   3.8968029822629166`*^9, 3.896807932514515*^9, 3.8968216741632376`*^9, 
   3.8968218760340176`*^9, 3.8968239500650587`*^9, 3.8968242370296483`*^9, 
   3.896913150004572*^9, 3.896914434255205*^9, 3.8969812743363624`*^9, 
   3.8969816687530165`*^9, 3.8972381626498013`*^9, 3.8972389130930004`*^9, 
   3.897397255394503*^9, 3.897426513697817*^9, 3.897518980730382*^9, 
   3.8975810608318033`*^9, 3.897581112450904*^9, 3.8977724894509788`*^9, {
   3.9011919795376415`*^9, 3.9011920087993937`*^9}},
 CellLabel->
  "During evaluation of \
In[162]:=",ExpressionUUID->"0affc17f-37f7-489d-b34c-99de6fd6a706"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for x", "Subsection",
 CellChangeTimes->{{3.626550877978876*^9, 
  3.6265508802988815`*^9}},ExpressionUUID->"ad7cc05f-3f24-4b67-b8ad-\
8c6d338446ef"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"str", "=", 
   RowBox[{"StringJoin", "[", "\"\<mexgetmatrices_x.txt\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{
      RowBox[{"Dimensions", "[", "A", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jj", "=", "1"}], ",", 
       RowBox[{"jj", "\[LessEqual]", 
        RowBox[{
         RowBox[{"Dimensions", "[", "A", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"jj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"temp", "=", 
         RowBox[{
          RowBox[{"Simplify", "[", 
           RowBox[{"A", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "]"}], "/.", 
          "outputrule"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"WriteString", "[", 
           RowBox[{"str", ",", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"\"\<A_sp_s[\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"ii", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"jj", "-", "1"}], ")"}], "*", "n"}], "-", "1", "+", 
                "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
              "\"\<;\\n\>\""}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"WriteString", "[", 
           RowBox[{"str", ",", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"\"\<A_sp_s[\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"ii", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"jj", "-", "1"}], ")"}], "*", "n"}], "-", "1", "+", 
                "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
              "\"\<;\\n\>\""}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
         "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{
      RowBox[{"Dimensions", "[", "B", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jj", "=", "1"}], ",", 
       RowBox[{"jj", "\[LessEqual]", 
        RowBox[{
         RowBox[{"Dimensions", "[", "B", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"jj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"temp", "=", 
         RowBox[{
          RowBox[{"Simplify", "[", 
           RowBox[{"B", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "]"}], "/.", 
          "outputrule"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"WriteString", "[", 
           RowBox[{"str", ",", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"\"\<B_sp_s[\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"ii", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"jj", "-", "1"}], ")"}], "*", "n"}], "-", "1", "+", 
                "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
              "\"\<;\\n\>\""}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"WriteString", "[", 
           RowBox[{"str", ",", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"\"\<B_sp_s[\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"ii", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"jj", "-", "1"}], ")"}], "*", "n"}], "-", "1", "+", 
                "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
              "\"\<;\\n\>\""}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
         "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "str", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.626548011166485*^9, 3.6265480477695646`*^9}, {
   3.6265480886026726`*^9, 3.6265483262082586`*^9}, 3.626612548146349*^9, {
   3.6266215911959257`*^9, 3.626621597889943*^9}, {3.708278891413886*^9, 
   3.708278893561058*^9}, {3.7084250477155037`*^9, 3.7084251553471518`*^9}, {
   3.7084252755201335`*^9, 3.7084252844062448`*^9}, {3.7084255186573896`*^9, 
   3.7084255971393895`*^9}, {3.708425779949358*^9, 3.708425788427856*^9}, {
   3.842364439653512*^9, 3.842364448553194*^9}, {3.8430716325745406`*^9, 
   3.8430716353622932`*^9}, {3.8430724957820234`*^9, 
   3.8430725002429447`*^9}, {3.843077072717663*^9, 3.843077085384571*^9}, {
   3.843155420498616*^9, 3.843155420666417*^9}, {3.843155690695469*^9, 
   3.843155692176098*^9}, {3.8431576277339334`*^9, 3.8431577329253917`*^9}, {
   3.8431577835692987`*^9, 3.843157784433031*^9}, {3.843159207452276*^9, 
   3.8431592140338387`*^9}, {3.8431592447538614`*^9, 
   3.8431592525025034`*^9}, {3.8432256062048793`*^9, 3.843225610184716*^9}, {
   3.8635349160662427`*^9, 3.8635349210485597`*^9}, 3.8635424712404146`*^9},
 CellLabel->
  "In[163]:=",ExpressionUUID->"f84d18bc-6439-4f32-8887-0015aa640a58"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for \[Epsilon]", "Subsection",
 CellChangeTimes->{{3.626550883437888*^9, 
  3.626550887241897*^9}},ExpressionUUID->"3b5f6a04-3a59-435a-866f-\
0bd18c0072e4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"str", "=", 
   RowBox[{"StringJoin", "[", "\"\<mexgetmatrices_e.txt\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{
      RowBox[{"Dimensions", "[", "C\[Epsilon]", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jj", "=", "1"}], ",", 
       RowBox[{"jj", "\[LessEqual]", 
        RowBox[{
         RowBox[{"Dimensions", "[", "C\[Epsilon]", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"jj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"temp", "=", 
         RowBox[{
          RowBox[{"Simplify", "[", 
           RowBox[{"C\[Epsilon]", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "]"}], "/.", 
          "outputrule"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"WriteString", "[", 
           RowBox[{"str", ",", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"\"\<Ce_sp_s[\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"ii", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"jj", "-", "1"}], ")"}], "*", "n"}], "-", "1", "+", 
                "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
              "\"\<;\\n\>\""}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"WriteString", "[", 
           RowBox[{"str", ",", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"\"\<Ce_sp_s[\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"ii", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"jj", "-", "1"}], ")"}], "*", "n"}], "-", "1", "+", 
                "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
              "\"\<;\\n\>\""}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
         "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{
      RowBox[{"Dimensions", "[", "D\[Epsilon]", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jj", "=", "1"}], ",", 
       RowBox[{"jj", "\[LessEqual]", 
        RowBox[{
         RowBox[{"Dimensions", "[", "D\[Epsilon]", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"jj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"temp", "=", 
         RowBox[{
          RowBox[{"Simplify", "[", 
           RowBox[{"D\[Epsilon]", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "]"}], "/.", 
          "outputrule"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"WriteString", "[", 
           RowBox[{"str", ",", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"\"\<De_sp_s[\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"ii", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"jj", "-", "1"}], ")"}], "*", "n"}], "-", "1", "+", 
                "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
              "\"\<;\\n\>\""}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"WriteString", "[", 
           RowBox[{"str", ",", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"\"\<De_sp_s[\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"ii", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"jj", "-", "1"}], ")"}], "*", "n"}], "-", "1", "+", 
                "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
              "\"\<;\\n\>\""}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
         "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "str", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.626548011166485*^9, 3.6265480477695646`*^9}, {
   3.6265480886026726`*^9, 3.6265483262082586`*^9}, {3.626550893601911*^9, 
   3.626550969844068*^9}, 3.62661254853435*^9, {3.6266215993299465`*^9, 
   3.626621603669956*^9}, {3.7084252939572897`*^9, 3.708425299203765*^9}, {
   3.70842560580439*^9, 3.70842563226639*^9}, {3.7084256646003895`*^9, 
   3.7084256825583897`*^9}, {3.842364451198234*^9, 3.8423644535498686`*^9}, {
   3.8430716382541375`*^9, 3.843071643202115*^9}, {3.8430725029663577`*^9, 
   3.843072504669488*^9}, {3.84307708847042*^9, 3.8430770936937013`*^9}, {
   3.8431588475745916`*^9, 3.8431588482451496`*^9}, {3.843224120645441*^9, 
   3.8432241444565916`*^9}, {3.843224419779687*^9, 3.8432244295022035`*^9}, {
   3.843225621460065*^9, 3.8432256300687065`*^9}, {3.863534928405161*^9, 
   3.8635349308298607`*^9}, 3.863542104731696*^9},
 CellLabel->
  "In[167]:=",ExpressionUUID->"02313f4e-02ed-49b0-b011-6cb640f9f92d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for \[Chi]", "Subsection",
 CellChangeTimes->{{3.626550883437888*^9, 3.626550887241897*^9}, {
  3.6265515703605556`*^9, 
  3.626551570950557*^9}},ExpressionUUID->"b0d5478d-4504-48e0-9c9f-\
e9d5adb0acdb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"str", "=", 
   RowBox[{"StringJoin", "[", "\"\<mexgetmatrices_c.txt\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{
      RowBox[{"Dimensions", "[", "C\[Chi]", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jj", "=", "1"}], ",", 
       RowBox[{"jj", "\[LessEqual]", 
        RowBox[{
         RowBox[{"Dimensions", "[", "C\[Chi]", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"jj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"temp", "=", 
         RowBox[{
          RowBox[{"Simplify", "[", 
           RowBox[{"C\[Chi]", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "]"}], "/.", 
          "outputrule"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"WriteString", "[", 
           RowBox[{"str", ",", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"\"\<Cc_sp_s[\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"ii", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"jj", "-", "1"}], ")"}], "*", "n"}], "-", "1", "+", 
                "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
              "\"\<;\\n\>\""}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"WriteString", "[", 
           RowBox[{"str", ",", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"\"\<Cc_sp_s[\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"ii", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"jj", "-", "1"}], ")"}], "*", "n"}], "-", "1", "+", 
                "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
              RowBox[{"ToString", "[", 
               RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
              "\"\<;\\n\>\""}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
         "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"ii", "=", "1"}], ",", 
     RowBox[{"ii", "\[LessEqual]", 
      RowBox[{
       RowBox[{"Dimensions", "[", "D\[Chi]", "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ",", 
     RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"temp", "=", 
       RowBox[{
        RowBox[{"Simplify", "[", 
         RowBox[{"D\[Chi]", "[", 
          RowBox[{"[", "ii", "]"}], "]"}], "]"}], "/.", "outputrule"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"WriteString", "[", 
         RowBox[{"str", ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<Dc_sp_s[\>\"", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"ii", "-", "1", "+", "zero"}], "]"}], ",", "\"\<]=\>\"", 
            ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
            "\"\<;\\n\>\""}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"WriteString", "[", 
         RowBox[{"str", ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<Dc_sp_s[\>\"", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"ii", "-", "1", "+", "zero"}], "]"}], ",", "\"\<]=\>\"", 
            ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
            "\"\<;\\n\>\""}], "]"}]}], "]"}]}], "\[IndentingNewLine]", "]"}], 
      ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "str", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.626548011166485*^9, 3.6265480477695646`*^9}, {
   3.6265480886026726`*^9, 3.6265483262082586`*^9}, {3.626550893601911*^9, 
   3.626550969844068*^9}, {3.62655157238056*^9, 3.6265516157206755`*^9}, {
   3.626559640776318*^9, 3.6265596562598605`*^9}, 3.6266125488043504`*^9, {
   3.6266223615539513`*^9, 3.6266223686359673`*^9}, {3.7084253015965257`*^9, 
   3.708425309130772*^9}, {3.7084256375623894`*^9, 3.7084256482093897`*^9}, {
   3.7084256867113895`*^9, 3.7084257223563895`*^9}, {3.8423644567975297`*^9, 
   3.8423644591340466`*^9}, {3.8430716471725616`*^9, 
   3.8430716501943893`*^9}, {3.843072510582341*^9, 3.843072512655568*^9}, {
   3.843077097017074*^9, 3.843077102709095*^9}, {3.8431588514228644`*^9, 
   3.8431588518870907`*^9}, {3.8432241548976297`*^9, 3.843224175866455*^9}, {
   3.8432242237447743`*^9, 3.8432242251966405`*^9}, {3.8432256214665966`*^9, 
   3.8432256337569532`*^9}, {3.843226441592874*^9, 3.8432264457733045`*^9}, {
   3.863534933016897*^9, 3.8635349349489107`*^9}, 3.86354210308149*^9},
 CellLabel->
  "In[171]:=",ExpressionUUID->"e7e3ec02-5821-420f-8f90-08b35631e846"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for xx", "Subsection",
 CellChangeTimes->{{3.626550883437888*^9, 3.626550887241897*^9}, {
  3.6265515703605556`*^9, 3.626551570950557*^9}, {3.6265598884886885`*^9, 
  3.6265598887046995`*^9}},ExpressionUUID->"c63cf99d-35ff-49f3-acfa-\
d10eeb9db1a4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"str", "=", 
   RowBox[{"StringJoin", "[", "\"\<mexgetmatrices_xx.txt\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dim1", "=", 
   RowBox[{
    RowBox[{"Dimensions", "[", "Mxx", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{
      RowBox[{"Dimensions", "[", "Mxx", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jj", "=", "1"}], ",", 
       RowBox[{"jj", "\[LessEqual]", 
        RowBox[{
         RowBox[{"Dimensions", "[", "Mxx", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"jj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"temp", "=", 
         RowBox[{
          RowBox[{"Simplify", "[", 
           RowBox[{"Mxx", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "]"}], "/.", 
          "outputrule"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"WriteString", "[", 
            RowBox[{"str", ",", 
             RowBox[{"StringJoin", "[", 
              RowBox[{"\"\<Mxx_sp_s[\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"ii", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"jj", "-", "1"}], ")"}], "*", "dim1"}], "-", "1", 
                 "+", "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
               "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"WriteString", "[", 
            RowBox[{"str", ",", 
             RowBox[{"StringJoin", "[", 
              RowBox[{"\"\<Mxx_sp_s[\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"ii", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"jj", "-", "1"}], ")"}], "*", "dim1"}], "-", "1", 
                 "+", "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
               "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
     ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{
      RowBox[{"Dimensions", "[", "Nxx", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"temp", "=", 
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{"Nxx", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], "]"}], "/.", "outputrule"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"WriteString", "[", 
         RowBox[{"str", ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<Nxx_sp_s[\>\"", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"ii", "-", "1", "+", "zero"}], "]"}], ",", "\"\<]=\>\"", 
            ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
            "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"WriteString", "[", 
         RowBox[{"str", ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<Nxx_sp_s[\>\"", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"ii", "-", "1", "+", "zero"}], "]"}], ",", "\"\<]=\>\"", 
            ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
            "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "str", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.626548011166485*^9, 3.6265480477695646`*^9}, {
   3.6265480886026726`*^9, 3.6265483262082586`*^9}, {3.626550893601911*^9, 
   3.626550969844068*^9}, {3.62655157238056*^9, 3.6265516157206755`*^9}, {
   3.626559640776318*^9, 3.6265596562598605`*^9}, {3.6265598900797567`*^9, 
   3.6265599488178797`*^9}, {3.626560421777522*^9, 3.6265604317287507`*^9}, 
   3.6265606770712457`*^9, {3.626560794222206*^9, 3.6265607979122443`*^9}, {
   3.62656107580958*^9, 3.6265610769295807`*^9}, {3.6265611431336737`*^9, 
   3.626561143983675*^9}, 3.626612549054351*^9, {3.6266223818109965`*^9, 
   3.626622384381002*^9}, {3.631051990657571*^9, 3.631051994824643*^9}, {
   3.6310520783860826`*^9, 3.631052089377344*^9}, {3.708425311290556*^9, 
   3.7084253188168035`*^9}, {3.7084258203224688`*^9, 3.7084258661316533`*^9}, 
   3.708425903202835*^9, {3.708426005483013*^9, 3.7084260182568855`*^9}, {
   3.7084261138606715`*^9, 3.7084261211485777`*^9}, {3.8430541107930975`*^9, 
   3.843054116959569*^9}, {3.8430716535857315`*^9, 3.843071656393655*^9}, {
   3.84307423862099*^9, 3.8430742431334734`*^9}, {3.8430771073921766`*^9, 
   3.8430771094804225`*^9}, 3.8431588568769073`*^9, {3.8432256214665966`*^9, 
   3.8432256352826405`*^9}, {3.8432328449065742`*^9, 
   3.8432330189363832`*^9}, {3.8432355668780766`*^9, 
   3.8432355774745736`*^9}, {3.8432357560831175`*^9, 
   3.8432357699634027`*^9}, {3.843325081345083*^9, 3.843325086084154*^9}, {
   3.8433261277398334`*^9, 3.8433261292678347`*^9}, {3.8635349369082403`*^9, 
   3.8635349390957117`*^9}, 3.863542099839368*^9},
 CellLabel->
  "In[175]:=",ExpressionUUID->"3b76ba22-8c13-4a9c-bfc0-beb41aaa671e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for x, \[Epsilon]", "Subsection",
 CellChangeTimes->{{3.626550883437888*^9, 3.626550887241897*^9}, {
  3.6265515703605556`*^9, 3.626551570950557*^9}, {3.6265598884886885`*^9, 
  3.6265598887046995`*^9}, {3.6265611581746955`*^9, 
  3.6265611587346964`*^9}},ExpressionUUID->"18f101b5-6239-466a-9955-\
d4011716add7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"str", "=", 
   RowBox[{"StringJoin", "[", "\"\<mexgetmatrices_xe.txt\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dim1", "=", 
   RowBox[{
    RowBox[{"Dimensions", "[", "Mx\[Epsilon]", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{
      RowBox[{"Dimensions", "[", "Mx\[Epsilon]", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jj", "=", "1"}], ",", 
       RowBox[{"jj", "\[LessEqual]", 
        RowBox[{
         RowBox[{"Dimensions", "[", "Mx\[Epsilon]", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"jj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"temp", "=", 
         RowBox[{
          RowBox[{"Simplify", "[", 
           RowBox[{"Mx\[Epsilon]", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "]"}], "/.", 
          "outputrule"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"WriteString", "[", 
            RowBox[{"str", ",", 
             RowBox[{"StringJoin", "[", 
              RowBox[{"\"\<Mxe_sp_s[\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"ii", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"jj", "-", "1"}], ")"}], "*", "dim1"}], "-", "1", 
                 "+", "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
               "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"WriteString", "[", 
            RowBox[{"str", ",", 
             RowBox[{"StringJoin", "[", 
              RowBox[{"\"\<Mxe_sp_s[\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"ii", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"jj", "-", "1"}], ")"}], "*", "dim1"}], "-", "1", 
                 "+", "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
               "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
     ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{
      RowBox[{"Dimensions", "[", "Nx\[Epsilon]", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"temp", "=", 
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{"Nx\[Epsilon]", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], "]"}], "/.", "outputrule"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"WriteString", "[", 
         RowBox[{"str", ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<Nxe_sp_s[\>\"", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"ii", "-", "1", "+", "zero"}], "]"}], ",", "\"\<]=\>\"", 
            ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
            "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"WriteString", "[", 
         RowBox[{"str", ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<Nxe_sp_s[\>\"", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"ii", "-", "1", "+", "zero"}], "]"}], ",", "\"\<]=\>\"", 
            ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
            "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "str", "]"}], ";"}]}], "Input",
 CellChangeTimes->{
  3.842054110470357*^9, {3.8430541185633497`*^9, 3.8430541236533237`*^9}, {
   3.8430716597850924`*^9, 3.8430716633273373`*^9}, {3.8430780193930416`*^9, 
   3.84307802742463*^9}, 3.8431588592819786`*^9, {3.8432256214665966`*^9, 
   3.843225637706423*^9}, {3.8432355983240533`*^9, 3.8432356190077085`*^9}, {
   3.843235665223948*^9, 3.8432356673468485`*^9}, {3.8432357467843018`*^9, 
   3.8432357499601965`*^9}, {3.8433248583595076`*^9, 3.843324860237424*^9}, {
   3.843326131477839*^9, 3.843326135478851*^9}, {3.8433269193839283`*^9, 
   3.8433269208679266`*^9}, {3.8635349428003607`*^9, 
   3.8635349449161587`*^9}, {3.863542091125454*^9, 3.863542097148226*^9}},
 CellLabel->
  "In[180]:=",ExpressionUUID->"4117c412-3f88-4df3-b806-957cbc6d1695"],

Cell[BoxData[
 TemplateBox[{
  "Simplify", "time", 
   "\"Time spent on a transformation exceeded \
\\!\\(\\*RowBox[{\\\"300.`\\\"}]\\) seconds, and the transformation was \
aborted. Increasing the value of TimeConstraint option may improve the result \
of simplification.\"", 2, 183, 14, 25513626908261174456, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9012124017465124`*^9},
 CellLabel->
  "During evaluation of \
In[180]:=",ExpressionUUID->"cf23eb25-2d43-4367-913f-c805df00be78"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for x, \[Chi]", "Subsection",
 CellChangeTimes->{{3.626550883437888*^9, 3.626550887241897*^9}, {
  3.6265515703605556`*^9, 3.626551570950557*^9}, {3.6265598884886885`*^9, 
  3.6265598887046995`*^9}, {3.6265611581746955`*^9, 3.6265611587346964`*^9}, {
  3.6265617485018196`*^9, 
  3.626561749141821*^9}},ExpressionUUID->"6abe49f8-9495-476b-abf6-\
c75ef0aee328"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"str", "=", 
   RowBox[{"StringJoin", "[", "\"\<mexgetmatrices_xc.txt\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dim1", "=", 
   RowBox[{
    RowBox[{"Dimensions", "[", "Mx\[Chi]", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{
      RowBox[{"Dimensions", "[", "Mx\[Chi]", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jj", "=", "1"}], ",", 
       RowBox[{"jj", "\[LessEqual]", 
        RowBox[{
         RowBox[{"Dimensions", "[", "Mx\[Chi]", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"jj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"temp", "=", 
         RowBox[{
          RowBox[{"Simplify", "[", 
           RowBox[{"Mx\[Chi]", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "]"}], "/.", 
          "outputrule"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"WriteString", "[", 
            RowBox[{"str", ",", 
             RowBox[{"StringJoin", "[", 
              RowBox[{"\"\<Mxc_sp_s[\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"ii", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"jj", "-", "1"}], ")"}], "*", "dim1"}], "-", "1", 
                 "+", "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
               "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"WriteString", "[", 
            RowBox[{"str", ",", 
             RowBox[{"StringJoin", "[", 
              RowBox[{"\"\<Mxc_sp_s[\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"ii", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"jj", "-", "1"}], ")"}], "*", "dim1"}], "-", "1", 
                 "+", "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
               "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
     ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{
      RowBox[{"Dimensions", "[", "Nx\[Chi]", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"temp", "=", 
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{"Nx\[Chi]", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], "]"}], "/.", "outputrule"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"WriteString", "[", 
         RowBox[{"str", ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<Nxc_sp_s[\>\"", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"ii", "-", "1", "+", "zero"}], "]"}], ",", "\"\<]=\>\"", 
            ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
            "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"WriteString", "[", 
         RowBox[{"str", ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<Nxc_sp_s[\>\"", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"ii", "-", "1", "+", "zero"}], "]"}], ",", "\"\<]=\>\"", 
            ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
            "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "str", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.626548011166485*^9, 3.6265480477695646`*^9}, {
   3.6265480886026726`*^9, 3.6265483262082586`*^9}, {3.626550893601911*^9, 
   3.626550969844068*^9}, {3.62655157238056*^9, 3.6265516157206755`*^9}, {
   3.626559640776318*^9, 3.6265596562598605`*^9}, {3.6265598900797567`*^9, 
   3.6265599488178797`*^9}, {3.626560421777522*^9, 3.6265604317287507`*^9}, 
   3.6265606770712457`*^9, {3.626560794222206*^9, 3.6265607979122443`*^9}, {
   3.62656107580958*^9, 3.6265610769295807`*^9}, {3.6265611431336737`*^9, 
   3.6265612076957655`*^9}, {3.6265616913727317`*^9, 3.6265617864108734`*^9}, 
   3.6265618978451433`*^9, {3.6265649502227364`*^9, 3.626564950950739*^9}, 
   3.626612549556352*^9, {3.62662239274802*^9, 3.626622396031027*^9}, {
   3.7084281431620965`*^9, 3.7084281921830964`*^9}, {3.70843019741813*^9, 
   3.708430205327339*^9}, {3.8430541256730566`*^9, 3.8430541299281497`*^9}, {
   3.843071669392419*^9, 3.8430716723695617`*^9}, {3.8430780299463177`*^9, 
   3.8430780354744368`*^9}, 3.843158862956488*^9, {3.8432256214665966`*^9, 
   3.843225639490589*^9}, {3.8432356303076134`*^9, 3.843235633013811*^9}, {
   3.8432356715444326`*^9, 3.843235673749916*^9}, {3.8432357405198946`*^9, 
   3.8432357428722057`*^9}, {3.8433269233369603`*^9, 
   3.8433269270370646`*^9}, {3.8485251386112823`*^9, 3.848525142036394*^9}, {
   3.863534948165517*^9, 3.863534951272148*^9}, 3.8635421077914815`*^9},
 CellLabel->
  "In[185]:=",ExpressionUUID->"e0cd4569-306a-44fb-ac5b-fa3b62e60bcb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for \[Epsilon], \[Epsilon]", "Subsection",
 CellChangeTimes->{{3.626550883437888*^9, 3.626550887241897*^9}, {
  3.6265515703605556`*^9, 3.626551570950557*^9}, {3.6265598884886885`*^9, 
  3.6265598887046995`*^9}, {3.6265611581746955`*^9, 3.6265611587346964`*^9}, {
  3.6265617485018196`*^9, 3.626561749141821*^9}, {3.6265618288009586`*^9, 
  3.6265618314589634`*^9}},ExpressionUUID->"c43fba78-8ceb-4039-8f08-\
b85b92a212eb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"str", "=", 
   RowBox[{"StringJoin", "[", "\"\<mexgetmatrices_ee.txt\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dim1", "=", 
   RowBox[{
    RowBox[{"Dimensions", "[", "M\[Epsilon]\[Epsilon]", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{
      RowBox[{"Dimensions", "[", "M\[Epsilon]\[Epsilon]", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jj", "=", "1"}], ",", 
       RowBox[{"jj", "\[LessEqual]", 
        RowBox[{
         RowBox[{"Dimensions", "[", "M\[Epsilon]\[Epsilon]", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"jj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"temp", "=", 
         RowBox[{
          RowBox[{"Simplify", "[", 
           RowBox[{"M\[Epsilon]\[Epsilon]", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "]"}], "/.", 
          "outputrule"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"WriteString", "[", 
            RowBox[{"str", ",", 
             RowBox[{"StringJoin", "[", 
              RowBox[{"\"\<Mee_sp_s[\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"ii", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"jj", "-", "1"}], ")"}], "*", "dim1"}], "-", "1", 
                 "+", "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
               "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"WriteString", "[", 
            RowBox[{"str", ",", 
             RowBox[{"StringJoin", "[", 
              RowBox[{"\"\<Mee_sp_s[\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"ii", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"jj", "-", "1"}], ")"}], "*", "dim1"}], "-", "1", 
                 "+", "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
               "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
     ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{
      RowBox[{"Dimensions", "[", "N\[Epsilon]\[Epsilon]", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"temp", "=", 
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{"N\[Epsilon]\[Epsilon]", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], "]"}], "/.", "outputrule"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"WriteString", "[", 
         RowBox[{"str", ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<Nee_sp_s[\>\"", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"ii", "-", "1", "+", "zero"}], "]"}], ",", "\"\<]=\>\"", 
            ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
            "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"WriteString", "[", 
         RowBox[{"str", ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<Nee_sp_s[\>\"", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"ii", "-", "1", "+", "zero"}], "]"}], ",", "\"\<]=\>\"", 
            ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
            "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "str", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.626548011166485*^9, 3.6265480477695646`*^9}, {
   3.6265480886026726`*^9, 3.6265483262082586`*^9}, {3.626550893601911*^9, 
   3.626550969844068*^9}, {3.62655157238056*^9, 3.6265516157206755`*^9}, {
   3.626559640776318*^9, 3.6265596562598605`*^9}, {3.6265598900797567`*^9, 
   3.6265599488178797`*^9}, {3.626560421777522*^9, 3.6265604317287507`*^9}, 
   3.6265606770712457`*^9, {3.626560794222206*^9, 3.6265607979122443`*^9}, {
   3.62656107580958*^9, 3.6265610769295807`*^9}, {3.6265611431336737`*^9, 
   3.6265612076957655`*^9}, {3.6265616913727317`*^9, 
   3.6265617864108734`*^9}, {3.6265618341389666`*^9, 3.6265618734850245`*^9}, 
   3.626612549816353*^9, {3.6266223974910297`*^9, 3.626622400931036*^9}, {
   3.708428204719096*^9, 3.7084282514990964`*^9}, {3.7084306788899164`*^9, 
   3.708430687288916*^9}, {3.842727813861038*^9, 3.8427278266522865`*^9}, {
   3.8427298876544456`*^9, 3.8427298952753844`*^9}, {3.8430541323172665`*^9, 
   3.8430541373018355`*^9}, {3.8430716753910713`*^9, 3.84307167849782*^9}, {
   3.843078038203538*^9, 3.8430780437614727`*^9}, 3.84315886647847*^9, {
   3.8432256214665966`*^9, 3.843225642219352*^9}, {3.8432356371714334`*^9, 
   3.8432356392646103`*^9}, {3.8432356779922223`*^9, 3.843235680684264*^9}, {
   3.8432357336316023`*^9, 3.8432357373698025`*^9}, {3.86353495378436*^9, 
   3.863534955873316*^9}, 3.8635421093890696`*^9},
 CellLabel->
  "In[190]:=",ExpressionUUID->"18a74f1c-85a1-4d34-985b-05f5f84f90ab"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for \[Epsilon], \[Chi]", "Subsection",
 CellChangeTimes->{{3.626550883437888*^9, 3.626550887241897*^9}, {
  3.6265515703605556`*^9, 3.626551570950557*^9}, {3.6265598884886885`*^9, 
  3.6265598887046995`*^9}, {3.6265611581746955`*^9, 3.6265611587346964`*^9}, {
  3.6265617485018196`*^9, 3.626561749141821*^9}, {3.6265618288009586`*^9, 
  3.6265618314589634`*^9}, {3.6265619071351566`*^9, 
  3.626561907395157*^9}},ExpressionUUID->"2b87f3d9-a0c5-43b8-88e2-\
1d4c423213f0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"str", "=", 
   RowBox[{"StringJoin", "[", "\"\<mexgetmatrices_ec.txt\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dim1", "=", 
   RowBox[{
    RowBox[{"Dimensions", "[", "M\[Epsilon]\[Chi]", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{
      RowBox[{"Dimensions", "[", "M\[Epsilon]\[Chi]", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jj", "=", "1"}], ",", 
       RowBox[{"jj", "\[LessEqual]", 
        RowBox[{
         RowBox[{"Dimensions", "[", "M\[Epsilon]\[Chi]", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"jj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"temp", "=", 
         RowBox[{
          RowBox[{"Simplify", "[", 
           RowBox[{"M\[Epsilon]\[Chi]", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "]"}], "/.", 
          "outputrule"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"WriteString", "[", 
            RowBox[{"str", ",", 
             RowBox[{"StringJoin", "[", 
              RowBox[{"\"\<Mec_sp_s[\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"ii", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"jj", "-", "1"}], ")"}], "*", "dim1"}], "-", "1", 
                 "+", "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
               "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"WriteString", "[", 
            RowBox[{"str", ",", 
             RowBox[{"StringJoin", "[", 
              RowBox[{"\"\<Mec_sp_s[\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"ii", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"jj", "-", "1"}], ")"}], "*", "dim1"}], "-", "1", 
                 "+", "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
               "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
     ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{
      RowBox[{"Dimensions", "[", "N\[Epsilon]\[Chi]", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"temp", "=", 
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{"N\[Epsilon]\[Chi]", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], "]"}], "/.", "outputrule"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"WriteString", "[", 
         RowBox[{"str", ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<Nec_sp_s[\>\"", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"ii", "-", "1", "+", "zero"}], "]"}], ",", "\"\<]=\>\"", 
            ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
            "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"WriteString", "[", 
         RowBox[{"str", ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<Nec_sp_s[\>\"", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"ii", "-", "1", "+", "zero"}], "]"}], ",", "\"\<]=\>\"", 
            ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
            "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}], ";"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "str", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.626548011166485*^9, 3.6265480477695646`*^9}, {
   3.6265480886026726`*^9, 3.6265483262082586`*^9}, {3.626550893601911*^9, 
   3.626550969844068*^9}, {3.62655157238056*^9, 3.6265516157206755`*^9}, {
   3.626559640776318*^9, 3.6265596562598605`*^9}, {3.6265598900797567`*^9, 
   3.6265599488178797`*^9}, {3.626560421777522*^9, 3.6265604317287507`*^9}, 
   3.6265606770712457`*^9, {3.626560794222206*^9, 3.6265607979122443`*^9}, {
   3.62656107580958*^9, 3.6265610769295807`*^9}, {3.6265611431336737`*^9, 
   3.6265612076957655`*^9}, {3.6265616913727317`*^9, 
   3.6265617864108734`*^9}, {3.6265618341389666`*^9, 
   3.6265618734850245`*^9}, {3.6265619089751587`*^9, 3.626561940056203*^9}, 
   3.6266125501063538`*^9, {3.626622403390042*^9, 3.6266224074310527`*^9}, {
   3.651577696895995*^9, 3.6515776972759957`*^9}, {3.7084282598600965`*^9, 
   3.7084282978570967`*^9}, {3.708430691968916*^9, 3.708430704647915*^9}, {
   3.7084314603284097`*^9, 3.7084314644577093`*^9}, {3.8427278324966116`*^9, 
   3.84272784020725*^9}, {3.8427298979659595`*^9, 3.842729903863583*^9}, {
   3.843054139173729*^9, 3.8430541437147512`*^9}, {3.843071681954767*^9, 
   3.8430716851965256`*^9}, {3.8430780456132116`*^9, 3.84307805164776*^9}, 
   3.843158868566288*^9, {3.8432256214665966`*^9, 3.8432256439021163`*^9}, {
   3.843235642616109*^9, 3.843235645828744*^9}, {3.8432356841634464`*^9, 
   3.8432357303623466`*^9}, {3.8635349696389723`*^9, 3.8635349721095686`*^9}, 
   3.8635421109126477`*^9},
 CellLabel->
  "In[195]:=",ExpressionUUID->"fb373ca2-f455-4d18-9055-ac620669c7c4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative for \[Chi], \[Chi]", "Subsection",
 CellChangeTimes->{{3.626550883437888*^9, 3.626550887241897*^9}, {
  3.6265515703605556`*^9, 3.626551570950557*^9}, {3.6265598884886885`*^9, 
  3.6265598887046995`*^9}, {3.6265611581746955`*^9, 3.6265611587346964`*^9}, {
  3.6265617485018196`*^9, 3.626561749141821*^9}, {3.6265618288009586`*^9, 
  3.6265618314589634`*^9}, {3.6265619071351566`*^9, 3.626561907395157*^9}, {
  3.626561946746212*^9, 
  3.6265619472462125`*^9}},ExpressionUUID->"cb07b27c-9b87-4eb3-a270-\
7d577adc4ed2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"str", "=", 
   RowBox[{"StringJoin", "[", "\"\<mexgetmatrices_cc.txt\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dim1", "=", 
   RowBox[{
    RowBox[{"Dimensions", "[", "M\[Chi]\[Chi]", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{
      RowBox[{"Dimensions", "[", "M\[Chi]\[Chi]", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"jj", "=", "1"}], ",", 
       RowBox[{"jj", "\[LessEqual]", 
        RowBox[{
         RowBox[{"Dimensions", "[", "M\[Chi]\[Chi]", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"jj", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"temp", "=", 
         RowBox[{
          RowBox[{"Simplify", "[", 
           RowBox[{"M\[Chi]\[Chi]", "[", 
            RowBox[{"[", 
             RowBox[{"ii", ",", "jj"}], "]"}], "]"}], "]"}], "/.", 
          "outputrule"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"WriteString", "[", 
            RowBox[{"str", ",", 
             RowBox[{"StringJoin", "[", 
              RowBox[{"\"\<Mcc_sp_s[\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"ii", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"jj", "-", "1"}], ")"}], "*", "dim1"}], "-", "1", 
                 "+", "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
               "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"WriteString", "[", 
            RowBox[{"str", ",", 
             RowBox[{"StringJoin", "[", 
              RowBox[{"\"\<Mcc_sp_s[\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"ii", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"jj", "-", "1"}], ")"}], "*", "dim1"}], "-", "1", 
                 "+", "zero"}], "]"}], ",", "\"\<]=\>\"", ",", 
               RowBox[{"ToString", "[", 
                RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
               "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
     ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"ii", "=", "1"}], ",", 
    RowBox[{"ii", "\[LessEqual]", 
     RowBox[{
      RowBox[{"Dimensions", "[", "N\[Chi]\[Chi]", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", 
    RowBox[{"ii", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"temp", "=", 
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{"N\[Chi]\[Chi]", "[", 
         RowBox[{"[", "ii", "]"}], "]"}], "]"}], "/.", "outputrule"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"temp", "\[Equal]", "0"}], ",", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{"Nothing", " ", "if", " ", "True"}], "*)"}], " ", ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"WriteString", "[", 
         RowBox[{"str", ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<Ncc_sp_s[\>\"", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"ii", "-", "1", "+", "zero"}], "]"}], ",", "\"\<]=\>\"", 
            ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
            "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"WriteString", "[", 
         RowBox[{"str", ",", 
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<Ncc_sp_s[\>\"", ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"ii", "-", "1", "+", "zero"}], "]"}], ",", "\"\<]=\>\"", 
            ",", 
            RowBox[{"ToString", "[", 
             RowBox[{"CForm", "[", "temp", "]"}], "]"}], ",", 
            "\"\<;\\n\>\""}], "]"}]}], "]"}], ";"}]}], "\[IndentingNewLine]", 
      "]"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "str", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.626548011166485*^9, 3.6265480477695646`*^9}, {
   3.6265480886026726`*^9, 3.6265483262082586`*^9}, {3.626550893601911*^9, 
   3.626550969844068*^9}, {3.62655157238056*^9, 3.6265516157206755`*^9}, {
   3.626559640776318*^9, 3.6265596562598605`*^9}, {3.6265598900797567`*^9, 
   3.6265599488178797`*^9}, {3.626560421777522*^9, 3.6265604317287507`*^9}, 
   3.6265606770712457`*^9, {3.626560794222206*^9, 3.6265607979122443`*^9}, {
   3.62656107580958*^9, 3.6265610769295807`*^9}, {3.6265611431336737`*^9, 
   3.6265612076957655`*^9}, {3.6265616913727317`*^9, 
   3.6265617864108734`*^9}, {3.6265618341389666`*^9, 
   3.6265618734850245`*^9}, {3.6265619089751587`*^9, 3.6265619837492743`*^9}, 
   3.6265628438362317`*^9, 3.6266125506363544`*^9, {3.6266224126840634`*^9, 
   3.6266224166110716`*^9}, {3.7084283046490965`*^9, 
   3.7084283480220966`*^9}, {3.7084307095759153`*^9, 3.708430718974915*^9}, {
   3.8427278420422535`*^9, 3.8427278500743375`*^9}, {3.842729906586026*^9, 
   3.8427299124846287`*^9}, {3.843054145747716*^9, 3.8430541475349913`*^9}, {
   3.8430565955187387`*^9, 3.843056597349047*^9}, {3.8430716890732565`*^9, 
   3.8430716912632647`*^9}, {3.843073457947315*^9, 3.84307346418347*^9}, {
   3.843073584299571*^9, 3.843073587829727*^9}, {3.8430780572240715`*^9, 
   3.843078070824568*^9}, 3.8431588710648994`*^9, {3.843225621483512*^9, 
   3.843225645686153*^9}, {3.843235649757428*^9, 3.843235652829003*^9}, {
   3.8432356952782307`*^9, 3.8432357093106346`*^9}, {3.8635349742660275`*^9, 
   3.8635349765665245`*^9}, 3.863542112852586*^9},
 CellLabel->
  "In[200]:=",ExpressionUUID->"3b67a046-ed03-494d-bd1e-8e60a7d7e8d7"],

Cell[BoxData[" "], "Input",
 CellChangeTimes->{3.8726335357712812`*^9},
 CellLabel->
  "In[205]:=",ExpressionUUID->"cbb12755-ed40-476a-9c30-54c1186c558e"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1440., 747.75},
WindowMargins->{{-6, Automatic}, {Automatic, -6}},
DockedCells->{},
FrontEndVersion->"13.1 for Microsoft Windows (64-bit) (August 22, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"52a06dd2-0e4e-4f8a-94ea-c968bcd79888"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 198, 4, 67, "Section",ExpressionUUID->"380c2fbf-221d-450f-85c0-947532017042"],
Cell[CellGroupData[{
Cell[790, 30, 160, 3, 54, "Subsection",ExpressionUUID->"5d7d8a07-3a1c-4c15-9387-b52979426b30"],
Cell[CellGroupData[{
Cell[975, 37, 709, 15, 67, "Input",ExpressionUUID->"7ed69aaa-fe6c-44dc-8f5a-308014ce3dd6"],
Cell[1687, 54, 386, 9, 28, "Message",ExpressionUUID->"7c1a088b-924f-45ca-a35c-5624f15862d7"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2122, 69, 159, 3, 54, "Subsection",ExpressionUUID->"9d2ba320-92f3-4400-abf7-fc4cd642321e"],
Cell[2284, 74, 1642, 31, 86, "Input",ExpressionUUID->"93295281-a532-452e-b35e-6c9eae7b620e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3963, 110, 166, 3, 54, "Subsection",ExpressionUUID->"823f04fd-5084-4dd0-963d-7a55f69e6b27"],
Cell[4132, 115, 17343, 506, 1091, "Input",ExpressionUUID->"1be30df0-4127-41a0-81a0-2cf46a6c5e98"],
Cell[21478, 623, 1176, 31, 86, "Input",ExpressionUUID->"307cd374-b37d-428e-bfa4-91caf5dfb519"],
Cell[22657, 656, 617, 13, 67, "Input",ExpressionUUID->"01f49d2a-d511-4e40-84f2-c9dd64c177fc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23311, 674, 224, 4, 54, "Subsection",ExpressionUUID->"99d3dcb5-72b1-4e05-ac7d-1418b9cc98f9"],
Cell[23538, 680, 4221, 106, 409, "Input",ExpressionUUID->"1895bf6f-a3e6-4397-a61f-aa50bef231e7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27796, 791, 159, 3, 54, "Subsection",ExpressionUUID->"e763a51b-04a9-4605-8831-c99fb65eb0e6"],
Cell[27958, 796, 4855, 119, 409, "Input",ExpressionUUID->"9b118144-4a9d-4e09-9749-992a6155d44a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32850, 920, 165, 3, 54, "Subsection",ExpressionUUID->"f51ce925-ac65-4602-9836-bceecdc280bc"],
Cell[CellGroupData[{
Cell[33040, 927, 1421, 36, 162, "Input",ExpressionUUID->"e632ded4-949d-46db-a57c-d4d938fccacf"],
Cell[34464, 965, 672, 14, 22, "Print",ExpressionUUID->"82f77765-a16b-4672-b669-affda3be0d0b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35185, 985, 157, 3, 54, "Subsection",ExpressionUUID->"9d5f5a50-2a45-4706-9e3f-b66e58e96fb6"],
Cell[35345, 990, 1466, 42, 96, "Input",ExpressionUUID->"a8052c66-2efa-4526-968d-7023dceaef5f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36848, 1037, 242, 4, 54, "Subsection",ExpressionUUID->"9db40362-5f70-471e-963c-76afbf18607b"],
Cell[37093, 1043, 638, 15, 28, "Input",ExpressionUUID->"b187f6c1-2cc2-42fe-9dd1-72b2dd4bcff8"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37780, 1064, 164, 3, 67, "Section",ExpressionUUID->"1a79a8a6-8a0b-405f-8617-d0f0ac64d57c"],
Cell[CellGroupData[{
Cell[37969, 1071, 170, 3, 54, "Subsection",ExpressionUUID->"c2808c04-4b5d-47bc-a43b-0b6f0db2253a"],
Cell[38142, 1076, 41019, 588, 126, "Input",ExpressionUUID->"1e93a8ac-44ff-4ac9-9b2c-f4f3e1d768e3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[79198, 1669, 160, 3, 54, "Subsection",ExpressionUUID->"521d2405-beaa-4621-b279-7ef00b42a7c2"],
Cell[79361, 1674, 957, 21, 28, "Input",ExpressionUUID->"d2b37efc-e70c-4037-9151-04fd2962b242"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[80367, 1701, 226, 4, 67, "Section",ExpressionUUID->"e734adf6-27c3-4415-9ee0-f1997e0401a8"],
Cell[CellGroupData[{
Cell[80618, 1709, 161, 3, 54, "Subsection",ExpressionUUID->"4679d204-8bdc-41f4-818c-3a29e20504cf"],
Cell[80782, 1714, 1873, 42, 67, "Input",ExpressionUUID->"ce50f43c-4d92-4c9a-90f6-08035e7ec88f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82692, 1761, 339, 5, 54, "Subsection",ExpressionUUID->"3ea0882f-cf49-4fba-8602-4680e3e26fd9"],
Cell[CellGroupData[{
Cell[83056, 1770, 7594, 184, 257, "Input",ExpressionUUID->"8e594fd7-1259-439a-9307-e712fe5c1bf9"],
Cell[90653, 1956, 1377, 21, 22, "Print",ExpressionUUID->"facd3d71-6e94-4bbe-a9f4-d53651c4ef4b"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[92079, 1983, 175, 3, 54, "Subsection",ExpressionUUID->"f0e8c21b-5d6f-46dd-85cf-b403e7586209"],
Cell[CellGroupData[{
Cell[92279, 1990, 4999, 117, 162, "Input",ExpressionUUID->"1f8bbd5a-7ab7-495f-9cce-7f77e235a854"],
Cell[97281, 2109, 726, 12, 22, "Print",ExpressionUUID->"680c8b80-8bee-4074-842f-2bfbe4b1c4b4"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[98056, 2127, 224, 4, 54, "Subsection",ExpressionUUID->"45a0097f-15f9-48d1-a209-f05e39a2f953"],
Cell[CellGroupData[{
Cell[98305, 2135, 3290, 84, 86, "Input",ExpressionUUID->"ae0f7142-a470-48a0-a6ed-9943a05b617c"],
Cell[101598, 2221, 559, 9, 22, "Print",ExpressionUUID->"620839d2-7ea7-454a-8af6-f63987563d56"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[102218, 2237, 172, 3, 67, "Section",ExpressionUUID->"8a5b2199-1ba2-4a60-968d-35a057b1887d"],
Cell[CellGroupData[{
Cell[102415, 2244, 169, 3, 54, "Subsection",ExpressionUUID->"e95f4013-4cd0-4d81-be73-171d866f3eb4"],
Cell[102587, 2249, 2882, 87, 88, "Input",ExpressionUUID->"ba21f123-23c8-45f5-a382-b4a9dd0a0c08"]
}, Open  ]],
Cell[CellGroupData[{
Cell[105506, 2341, 159, 3, 54, "Subsection",ExpressionUUID->"7f4271d6-c5ba-44f1-b493-f8fa92e16e8b"],
Cell[105668, 2346, 3432, 101, 139, "Input",ExpressionUUID->"46582390-4853-469a-8bb8-0d3a293195c2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[109137, 2452, 220, 4, 54, "Subsection",ExpressionUUID->"88c2e078-5a27-4541-84f1-d4b0dab7e2dc"],
Cell[109360, 2458, 12307, 279, 504, "Input",ExpressionUUID->"6f7b3665-1806-46bd-a798-fb39717bb2d9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[121704, 2742, 277, 4, 54, "Subsection",ExpressionUUID->"bb141f46-fa25-4017-9882-bb68a380e46f"],
Cell[121984, 2748, 6662, 154, 333, "Input",ExpressionUUID->"1b8b7f01-17e9-41ee-bd5a-035203f7e576"]
}, Open  ]],
Cell[CellGroupData[{
Cell[128683, 2907, 316, 4, 54, "Subsection",ExpressionUUID->"449fd1aa-ccd6-4a43-97d5-fac0e74ffeaa"],
Cell[129002, 2913, 6677, 153, 295, "Input",ExpressionUUID->"a5d47e29-8574-485a-af53-e312051af503"]
}, Open  ]],
Cell[CellGroupData[{
Cell[135716, 3071, 382, 6, 54, "Subsection",ExpressionUUID->"032812ad-843e-4146-bf92-441052429500"],
Cell[136101, 3079, 12374, 281, 504, "Input",ExpressionUUID->"0b53d42c-d8e8-4a22-a46d-6a956ecae149"]
}, Open  ]],
Cell[CellGroupData[{
Cell[148512, 3365, 426, 6, 54, "Subsection",ExpressionUUID->"061f3404-cfa4-41a8-aa9f-c4d4d0863ef3"],
Cell[148941, 3373, 7021, 160, 333, "Input",ExpressionUUID->"c997c8c4-c3a2-48e8-a7c6-f15923db04a5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[155999, 3538, 471, 7, 54, "Subsection",ExpressionUUID->"05a76877-f922-4fda-8f03-33936442b3d2"],
Cell[156473, 3547, 7816, 178, 333, "Input",ExpressionUUID->"4490009d-397e-4587-9412-3358248c900e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[164338, 3731, 154, 3, 67, "Section",ExpressionUUID->"42e53149-82d1-4ce3-a6db-74501597abf1"],
Cell[CellGroupData[{
Cell[164517, 3738, 162, 3, 54, "Subsection",ExpressionUUID->"a758b6f9-2285-453a-a0be-8784b6f8f895"],
Cell[CellGroupData[{
Cell[164704, 3745, 7547, 172, 207, "Input",ExpressionUUID->"e8bc5a8c-d086-4caf-aff5-5ff67bd2b631"],
Cell[172254, 3919, 1589, 26, 28, "Message",ExpressionUUID->"5e8ec2cb-f047-44d6-bf71-d873eab74ccd"],
Cell[173846, 3947, 1617, 27, 28, "Message",ExpressionUUID->"23b5f3a9-605b-4bff-950d-f0dd4e843e40"],
Cell[175466, 3976, 1617, 27, 28, "Message",ExpressionUUID->"745730e4-aae8-43a0-acdc-7ce269ece8f5"],
Cell[177086, 4005, 1660, 27, 28, "Message",ExpressionUUID->"0affc17f-37f7-489d-b34c-99de6fd6a706"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[178795, 4038, 166, 3, 54, "Subsection",ExpressionUUID->"ad7cc05f-3f24-4b67-b8ad-8c6d338446ef"],
Cell[178964, 4043, 6321, 143, 428, "Input",ExpressionUUID->"f84d18bc-6439-4f32-8887-0015aa640a58"]
}, Open  ]],
Cell[CellGroupData[{
Cell[185322, 4191, 173, 3, 54, "Subsection",ExpressionUUID->"3b5f6a04-3a59-435a-866f-0bd18c0072e4"],
Cell[185498, 4196, 6171, 140, 428, "Input",ExpressionUUID->"02313f4e-02ed-49b0-b011-6cb640f9f92d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[191706, 4341, 220, 4, 54, "Subsection",ExpressionUUID->"b0d5478d-4504-48e0-9c9f-e9d5adb0acdb"],
Cell[191929, 4347, 5642, 127, 409, "Input",ExpressionUUID->"e7e3ec02-5821-420f-8f90-08b35631e846"]
}, Open  ]],
Cell[CellGroupData[{
Cell[197608, 4479, 266, 4, 54, "Subsection",ExpressionUUID->"c63cf99d-35ff-49f3-acfa-d10eeb9db1a4"],
Cell[197877, 4485, 6422, 145, 409, "Input",ExpressionUUID->"3b76ba22-8c13-4a9c-bfc0-beb41aaa671e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[204336, 4635, 330, 5, 54, "Subsection",ExpressionUUID->"18f101b5-6239-466a-9955-d4011716add7"],
Cell[CellGroupData[{
Cell[204691, 4644, 5585, 133, 409, "Input",ExpressionUUID->"4117c412-3f88-4df3-b806-957cbc6d1695"],
Cell[210279, 4779, 511, 11, 28, "Message",ExpressionUUID->"cf23eb25-2d43-4367-913f-c805df00be78"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[210839, 4796, 377, 6, 54, "Subsection",ExpressionUUID->"6abe49f8-9495-476b-abf6-c75ef0aee328"],
Cell[211219, 4804, 6314, 142, 428, "Input",ExpressionUUID->"e0cd4569-306a-44fb-ac5b-fa3b62e60bcb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[217570, 4951, 440, 6, 54, "Subsection",ExpressionUUID->"c43fba78-8ceb-4039-8f08-b85b92a212eb"],
Cell[218013, 4959, 6371, 142, 428, "Input",ExpressionUUID->"18a74f1c-85a1-4d34-985b-05f5f84f90ab"]
}, Open  ]],
Cell[CellGroupData[{
Cell[224421, 5106, 487, 7, 54, "Subsection",ExpressionUUID->"2b87f3d9-a0c5-43b8-88e2-1d4c423213f0"],
Cell[224911, 5115, 6454, 144, 428, "Input",ExpressionUUID->"fb373ca2-f455-4d18-9055-ac620669c7c4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[231402, 5264, 534, 8, 54, "Subsection",ExpressionUUID->"cb07b27c-9b87-4eb3-a270-7d577adc4ed2"],
Cell[231939, 5274, 6484, 145, 409, "Input",ExpressionUUID->"3b67a046-ed03-494d-bd1e-8e60a7d7e8d7"],
Cell[238426, 5421, 154, 3, 28, "Input",ExpressionUUID->"cbb12755-ed40-476a-9c30-54c1186c558e"]
}, Open  ]]
}, Open  ]]
}
]
*)

